package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMercgantAuthenticationParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantAuthSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.FbMerchantAuthenticationResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantAuthListResult;
import com.fshows.lifecircle.service.utils.KeyGenerator;
import com.fshows.lifecircle.service.utils.KeyTypeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantAuthenticationService;
import com.fshows.lifecircle.user.service.business.db.IUserMerchantAuthService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbMerchantAuthenticationMapper;
import com.fshows.lifecircle.user.service.domain.po.FbMerchantAuthentication;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class UserMerchantAuthServiceImpl implements IUserMerchantAuthService {


    @Autowired
    IFbMerchantAuthenticationService merchantAuthenticationService;

    @Autowired
    FbMerchantAuthenticationMapper merchantAuthenticationMapper;

    /**
     * 保存商户认证信息 ，保证数据库里最多只有一条
     * @param param
     * @return
     */
    @Override
    public BizResponse<FbMerchantAuthenticationResult> saveMerchantAuth(UserMercgantAuthenticationParam param) {

        FbMerchantAuthentication merchantAuthentication = BijectionUtils.invert(param, FbMerchantAuthentication.class);

        if (Objects.isNull(merchantAuthentication) || Objects.isNull(merchantAuthentication.getMid())) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }


        FbMerchantAuthentication record = merchantAuthenticationService.selectOne(new EntityWrapper<FbMerchantAuthentication>()
                .eq(FbMerchantAuthentication.MID, merchantAuthentication.getMid()));
        // 数据库没有记录
        if (Objects.isNull(record)) {

            if (Objects.isNull(merchantAuthentication.getAuthId())) {
                // save

                Long aLong = KeyGenerator.getKeyByType(KeyTypeEnum.COMMON_KEY);
                merchantAuthentication.setAuthId(aLong);
                 merchantAuthenticationService.insert(merchantAuthentication);

            }
        }else {  //数据库有纪律
            merchantAuthentication= BijectionUtils.invert(param, record);
            merchantAuthenticationService.update( merchantAuthentication,
                    new EntityWrapper<FbMerchantAuthentication>()
                            .eq(FbMerchantAuthentication.AUTH_ID, merchantAuthentication.getAuthId()));
        }

        FbMerchantAuthenticationResult result = BijectionUtils.invert(merchantAuthentication, FbMerchantAuthenticationResult.class);

        return BizResponse.success(result);
    }

    @Override
    public BizResponse<FbMerchantAuthenticationResult> getMerchantAuthDetail(Long mid) {
        FbMerchantAuthentication authentication = merchantAuthenticationService.selectOne(
                new EntityWrapper<FbMerchantAuthentication>()
                        .eq(FbMerchantAuthentication.MID, mid));

        if (Objects.isNull(authentication)) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        FbMerchantAuthenticationResult result = BijectionUtils.invert(authentication, FbMerchantAuthenticationResult.class);

        return BizResponse.success(result);
    }


    @Override
    public BizResponse<List<MerchantAuthListResult> > findFbMerchantAuthenticationResults(MerchantAuthSearchParam param) {

        Map<String, Object> paramMap = BijectionUtils.bean2Map(param);


        int startNum = (param.getPage() - 1) * param.getPageSize();
        paramMap.put("startNum", startNum);

        List<Map<String, Object>> mapRet = merchantAuthenticationMapper.selectListByCondition(paramMap);

        List<MerchantAuthListResult> listResults = BijectionUtils.mapsToObjects(mapRet, MerchantAuthListResult.class);

        return BizResponse.success(  listResults );

    }
}
