/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.app.StaffListParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffListResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserMerchantChildrenService {

    /**
     * 商户子账号信息添加
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> addUserMerchantChildren(UserMerchantChildrenParam param);

    /**
     * 商户子账号信息修改 根据baseId修改
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> updateUserMerchantChildren(UserMerchantChildrenParam param);


    /**
     * 查询子商户信息
     *
     * @param param
     * @return
     */
    BizResponse<MerchantChildDetailsResult> getUserMerchantChild(MerchantChildQueryParam param);


    BizResponse<Boolean> deleteUserMerchantChildrenByBaseId(Long baseId);

    BizResponse<MerchantChildrenDetailDTO> getUserMerchantChildrenByBaseId(Long baseId);

    BizResponse<PageResult<StaffListResult>> getStaffListResult(StaffListParam param);

    BizResponse<StaffDetailResult> getStaffDetailResult(Long uid);
}

