/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserAgentService {

    /**
     * 添加代理商信息
     *
     * @param userAgentParam
     * @return
     */
    BizResponse<UserAgentResult> addUserAgent(UserAgentParam userAgentParam);


    /**
     * 修改代理商信息
     *
     * @param userAgentParam
     * @return
     */
    BizResponse<Boolean> updateUserAgent(UserAgentParam userAgentParam);


    /**
     * 审核代理商信息
     *
     * @param agentId
     * @param checkStatus
     * @param remark
     * @return
     */
    BizResponse<Boolean> auditUserAgent(Long agentId, int checkStatus, String remark);

    /**
     * 查询代理商信息
     *
     * @param agentId
     * @return
     */
    BizResponse<AgentDetailDTO> queryUserAgentByAgentId(Long agentId);

    /**
     * 分页查询代理商信息
     *
     * @param agentQuery
     * @return
     */
    BizResponse<PageResult<UserAgentDTO>> queryUserAgentPage(AgentQuery agentQuery);


    /**
     * 分页查询授理商信息
     *
     * @param agentQuery
     * @return
     */
    BizResponse<PageResult<UserAgentDTO>> queryUserAgentGrantPage(AgentQuery agentQuery);


    /**
     * 根据agentId查询username和所属代理商公司名称
     *
     * @param agentId
     * @return
     */
    BizResponse<AgentUserAndBelongResult> queryUserAgentNameAndBelongAgengName(Long agentId);

    /**
     * 根据company判断是否存在
     *
     * @param company
     * @return
     */
    BizResponse<Boolean> existByCompany(String company);

    /**
     * 根据oemId获取某个oem下面的所有代理商/授理商
     *
     * @param oemId
     * @return
     */
    BizResponse<List<AgentSimpleResult>> getAllAgentListByOemId(Long oemId);


    /**
     * 统计代理商日数据
     * @param agentId
     * @return
     */
    BizResponse<AgentAdminIndexResult> statisticData(Long agentId);
}
