/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-18 22:32
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeRightDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-18 22:32
 * 更新记录：
 * @author BuHao
 */
public interface IOemNodeService {

  /**
   * 添加或修改 oem 节点对象
   * @param param
   * @return
   */
  Boolean addAndUpdateOemNode(OemNodeAddOrUpdateParam param);


  /**
   * oem 节点列表接口
   * @param param
   * @return
   */
  List<OemNodeResult> findByPage(OemNodeQueryParam param);

  /**
   *  獲取oem 所有node
   * @return
   */
    BizResponse<List<OemNodeRightDTO>> findALL();



  /**
   * 获得详情
   * @param id
   * @return
   */
  OemNodeDetailResult getById(Long id);

}
