/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightControlDTO;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserRightConfigService;
import com.fshows.lifecircle.user.service.business.db.*;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserRightConfigServiceImpl implements IUserRightConfigService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;

    @Autowired
    private IUserBaseService userBaseService;

    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;


    @Autowired
    private IFbMerchantRightConfigService fbMerchantRightConfigService;

    @Autowired
    private IFbAgentRightConfigService fbAgentRightConfigService;

    @Autowired
    private IFbOemRightConfigService fbOemRightConfigService;

    @Autowired
    private IFbMerchantRightControlService fbMerchantRightControlService;

    @Autowired
    private IFbAgentRightControlService fbAgentRightControlService;

    @Autowired
    private IFbOemRightControlService fbOemRightControlService;


    @Override
    public BizResponse<List<RightConfigDTO>> queryUserRightConfigList(UserType type) {

        List<RightConfigDTO> rightConfigList = new ArrayList<>();

        if(type == UserType.OEM){
            List<FbOemRightConfig> list = fbOemRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list ,RightConfigDTO.class);
        }

        if(type == UserType.AGENT || type == UserType.GRANT){
            List<FbAgentRightConfig> list = fbAgentRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list ,RightConfigDTO.class);
        }

        if(type == UserType.MERCHANT){
            List<FbMerchantRightConfig> list = fbMerchantRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list ,RightConfigDTO.class);
        }

        return BizResponse.success(rightConfigList);
    }

    @Override
    public BizResponse<List<RightControlDTO>> queryUserRightControlList(UserType type, long userId) {
        List<RightControlDTO> controlList = new ArrayList<>();

        if(type == UserType.OEM){
            List<FbOemRightControl> list = fbOemRightControlService.selectList(Condition.create().eq(FbOemRightControl.OEM_ID, userId));
            controlList = BijectionUtils.invertList(list ,RightControlDTO.class);
        }

        if(type == UserType.AGENT || type == UserType.GRANT){
            List<FbAgentRightControl> list = fbAgentRightControlService.selectList(Condition.create().eq(FbAgentRightControl.AGENT_ID, userId));
            controlList = BijectionUtils.invertList(list ,RightControlDTO.class);
        }

        if(type == UserType.MERCHANT){
            List<FbMerchantRightControl> list = fbMerchantRightControlService.selectList(Condition.create().eq(FbMerchantRightControl.MID, userId));
            controlList = BijectionUtils.invertList(list ,RightControlDTO.class);
        }

        return BizResponse.success(controlList);
    }
}
