/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenRoleParam;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightControlDTO;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserRightConfigService {

    /**
     * 按用户类型（oem/代理商/授理商/商户）获得功能权限列表接口
     *
     * @param type
     * @return
     */
    BizResponse<List<RightConfigDTO>> queryUserRightConfigList(UserType type);



    /**
     * 根据用户id 获得所拥有的功能权限列表
     *
     * @param type
     * @param type
     * @return
     */
    BizResponse<List<RightControlDTO>> queryUserRightControlList(UserType type, long userId);
}
