package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.db.IFbAgentRightControlService;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.business.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbAgentRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserAgentMapper;
import com.fshows.lifecircle.user.service.domain.po.FbAgentRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import java.util.Date;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 代理商权限控制关系表 服务实现类
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@Service
@Slf4j
public class FbAgentRightControlServiceImpl extends ServiceImpl<FbAgentRightControlMapper, FbAgentRightControl> implements
    IFbAgentRightControlService {
    @Autowired
    private FbAgentRightControlMapper fbAgentRightControlMapper;

    @Autowired
    private FbUserAgentMapper fbUserAgentMapper;

    /**
     * 新增或修改代理商权限
     * @param userId
     * @param array
     * @return
     */
    @Override
    public BizResponse<Boolean> updateAgentRightControl(Long userId, String[] array) {
        FbAgentRightControl fbAgentRightControl;
        log.info("updateAgentRightControl execute >> userId={}, array = {}", userId, array);
        try {
            //检查userId 是否合规
            FbUserAgent fbUserAgent = new FbUserAgent();
            fbUserAgent.setAgentId(userId);
            fbUserAgent = fbUserAgentMapper.selectOne(fbUserAgent);
            if (userId == null || array == null || fbUserAgent == null) {
                log.info("2.3.9 - 1, updateUserRightControl check fail, userId or array can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            //1、查询是否存在权限
            List<FbAgentRightControl> fbAgentRightControlList = fbAgentRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateUserRightControl 存储历史数据 fbAgentRightControlList = {}", JSON.toJSONString(fbAgentRightControlList));

            //2、如果存在权限，将旧权限全部删除
            if (fbAgentRightControlList.size() > 0) {
                fbAgentRightControlMapper.deleteByUserId(userId);
            }

            //3、重新创建新的权限
            Integer i = 0;
            for (String s : array) {
                fbAgentRightControl = new FbAgentRightControl();
                long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.CONTROL_KEY);
                fbAgentRightControl.setId(businessUniqId);
                fbAgentRightControl.setAgentId(userId);
                fbAgentRightControl.setRightKey(s);
                fbAgentRightControl.setIsOpen(1);
                fbAgentRightControl.setCreateTime(new Date());
                fbAgentRightControl.setUpdateTime(new Date());
                Integer addResultCount = fbAgentRightControlMapper.insert(fbAgentRightControl);
                i = i + addResultCount;
            }

            //4、添加失败删除 回滚数据
            if (i != array.length) {
                fbAgentRightControlMapper.deleteByUserId(userId);
                if (fbAgentRightControlList != null && fbAgentRightControlList.size() > 0) {
                    for (FbAgentRightControl control : fbAgentRightControlList) {
                        fbAgentRightControlMapper.insert(control);
                    }
                }
                return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(),ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }

            return BizResponse.success(Boolean.TRUE);

        } catch (Exception e) {
            log.error("2.3.9 - 3, 方法: updateUserRightControl 发生异常， 参数: userId = {}, array = {},异常: Ex = {}", userId, array,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }
}
