/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.user.service.business.biz.IUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.business.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbUserAgentMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.xiaoleilu.hutool.util.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserAgentServiceImpl implements IUserAgentService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;

    @Autowired
    private FbUserAgentMapper fbUserAgentMapper;

    @Override
    public BizResponse<UserAgentResult> addUserAgent(UserAgentParam param) {
        UserAgentResult userAgentResult = new UserAgentResult();
        log.info("1, addUserAgent execute >> para={}", JSON.toJSONString(param));
        try {

            if (param.getBaseId() == null || param.getOemId() == null) {
                log.info("1.1, addUserAgent check fail, baseId or oemId can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }

            FbUserAgent obj = new FbUserAgent();
            BeanUtils.copyProperties(param, obj);

            // 生成业务主键id
            long baseId = KeyGenerator.getKeyByType(KeyTypeEnum.AGENT_USER_KEY);
            obj.setAgentId(baseId);

            obj.setStatus(IUserConstants.DEFAULT_STATUS);

            boolean addResult = fbUserAgentService.insert(obj);


            if (addResult) {
                userAgentResult.setAgentId(obj.getAgentId());
                log.info("2, addUserAgent success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(userAgentResult);
            }

            log.info("3, addUserAgent fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: addUserAgent 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            boolean deleteResult = fbUserBaseService.delete(Condition.create().eq(FbUserBase.BASE_ID, param.getBaseId()));
            log.info("delete userbase deleteResult = {}, baseId = {}", deleteResult, param.getBaseId());
            return BizResponse.serverError();
        }

    }


    @Override
    public BizResponse<Boolean> updateUserAgent(UserAgentParam param) {
        log.info("1, updateUserAgent execute >> para={}", JSON.toJSONString(param));

        if (param.getAgentId() == null) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        long agentId = param.getAgentId();
        try {

            FbUserAgent obj = new FbUserAgent();
            BeanUtils.copyProperties(param, obj);

            boolean updateResult = fbUserAgentService.update(obj, Condition.create().eq(FbUserAgent.AGENT_ID, agentId));

            if (updateResult) {
                log.info("2, updateUserAgent success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, updateUserBase fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: updateUserAgent 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<Boolean> auditUserAgent(Long agentId, int checkStatus, String remark) {
        log.info("1, auditUserAgent execute >> agentId={}, checkStatus={}", agentId, checkStatus);

        if (agentId == null) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }

        try {

            FbUserAgent obj = new FbUserAgent();
            obj.setAgentId(agentId);
            obj.setCheckStatus(checkStatus);
            obj.setCheckTime(System.currentTimeMillis());
            obj.setRemark(remark);

            fbUserAgentService.update(obj, Condition.create().eq(FbUserAgent.AGENT_ID, agentId));
            log.info("2, auditUserAgent succrss >> agentId={}, checkStatus={}", agentId, checkStatus);

            return BizResponse.success(Boolean.TRUE);

        } catch (Exception e) {
            log.error("方法: auditUserAgent 发生异常， 参数: agentId = {} ,异常: Ex = {}", agentId,
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<AgentDetailDTO> queryUserAgentByAgentId(Long agentId) {

        /*agentDetailDTO  包含用户基础信息  和 代理商信息*/
        AgentDetailDTO agentDetailDTO = new AgentDetailDTO();

        FbUserAgent fbUserAgent = fbUserAgentService.selectOne(Condition.create().eq(FbUserAgent.AGENT_ID, agentId));

        AgentInfo agentInfo = BijectionUtils.invert(fbUserAgent, AgentInfo.class);

        if(agentInfo != null){
            FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create().eq(FbUserBase.BASE_ID, agentInfo.getBaseId()));
            BaseInfo baseInfo = BijectionUtils.invert(fbUserBase, BaseInfo.class);
            agentDetailDTO.setBaseInfo(baseInfo);
        }

        agentDetailDTO.setAgentInfo(agentInfo);

        return BizResponse.success(agentDetailDTO);
    }

    @Override
    public BizResponse<PageResult<UserAgentDTO>> queryUserAgentPage(AgentQuery agentQuery) {

        Map map = BeanUtil.beanToMap(agentQuery);

        int startNum = (agentQuery.getPage() - 1) * agentQuery.getPageSize();

        map.put("expire", agentQuery.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        map.put("startNum", startNum);

        List<Map<String, Object>> list = fbUserAgentMapper.queryUserAgentPage(map);

        int totalNum = fbUserAgentMapper.countUserAgentByCondition(map);


        List<UserAgentDTO> targetList = BijectionUtils.mapsToObjects(list, UserAgentDTO.class);

        System.out.println("agentId" + targetList.get(0).getAgentId());

        targetList.forEach(n -> System.out.println(n));

        PageResult<UserAgentDTO> pageResult = new PageResult(totalNum, list);

        return BizResponse.success(pageResult);
    }

    @Override
    public BizResponse<PageResult<UserAgentGrantDTO>> queryUserAgentGrantPage(AgentQuery agentQuery) {
        Map map = BeanUtil.beanToMap(agentQuery);

        int startNum = (agentQuery.getPage() - 1) * agentQuery.getPageSize();

        map.put("expire", agentQuery.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        map.put("startNum", startNum);

        List<Map<String, Object>> list = fbUserAgentMapper.queryUserAgentPage(map);

        int totalNum = fbUserAgentMapper.countUserAgentByCondition(map);

        List<UserAgentGrantDTO> targetList = BijectionUtils.mapsToObjects(list, UserAgentGrantDTO.class);

        //设置 belongName

        PageResult<UserAgentGrantDTO> pageResult = new PageResult(totalNum, list);

        return BizResponse.success(pageResult);
    }

    @Override
    public BizResponse<AgentUserAndBelongResult> queryUserAgentNameAndBelongAgengName(Long agentId) {

        Map<String, Object> map = fbUserAgentMapper.queryUserAgentNameAndBelongAgengName(agentId);
        AgentUserAndBelongResult result = BijectionUtils.mapToObject(map, AgentUserAndBelongResult.class);

        return BizResponse.success(result);
    }





}
