/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserMerchantService {

    /**
     * 添加商户信息
     *
     * @param param
     * @return
     */
    BizResponse<UserMerchantResult> addUserMerchant(UserMerchantParam param);


    /**
     * 修改商户信息
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> updateUserMerchant(UserMerchantParam param);


    /**
     * 查询商户信息
     *
     * @param mid
     * @return
     */
    BizResponse<MerchantDetailDTO> queryUserMerchantByMid(Long mid);


    /**
     * 分页查询 商户信息
     *
     * @param merchantQuery
     * @return
     */
    BizResponse<PageResult<UserMerchantDTO>> queryUserMerchantPage(MerchantQuery merchantQuery);

    /**
     * 按条件查询 商户信息信息列表 主要用于导出
     *
     * @param merchantQuery
     * @return
     */
    BizResponse<List<UserMerchantDTO>> queryUserMerchantListByCondition(MerchantQuery merchantQuery);

    /**
     * @author: spafka@github.com
     * @desc: 代理商条件搜索商户列表
     * @date: created on 2017-12-25 11:15:25.228
     * @return   List<MerchantListSeachByAgentResult>
     */
    BizResponse<List<MerchantListSeachByAgentResult>> findMerchantListByAgent(MerchantQueryByAgentParam param);

    /**
     * @author: spafka@github.com
     * @desc: 受理商条件搜索商户列表
     * @date: created on 2017-12-25 11:15:25.228
     * @return   List<MerchantListSeachByAgentResult>
     */
    BizResponse<List<MerchantListSeachByAgentResult>> findMerchantListByGrand(MerchantQueryByGradndParam param);
}

