/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.IUserConstants;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.business.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemConfig;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import com.xiaoleilu.hutool.util.BeanUtil;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserMerchantServiceImpl implements IUserMerchantService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;

    @Autowired
    private IUserBaseService userBaseService;

    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public BizResponse<UserMerchantResult> addUserMerchant(UserMerchantParam param) {
        UserMerchantResult userMerchantResult = new UserMerchantResult();
        log.info("1, addUserMerchant execute >> para={}", JSON.toJSONString(param));
        try {

            if (param.getBaseId() == null || param.getOemId() == null) {
                log.info("1.1, addUserMerchant check fail, baseId or oemId can not be null");
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }


            FbUserMerchant obj = new FbUserMerchant();
            BeanUtils.copyProperties(param, obj);

            // 生成业务主键id
            long businessUniqId = KeyGenerator.getKeyByType(KeyTypeEnum.MERCHANT_USER_KEY);
            obj.setMid(businessUniqId);

            obj.setStatus(IUserConstants.DEFAULT_STATUS);

            boolean addResult = fbUserMerchantService.insert(obj);

            if (addResult) {
                userMerchantResult.setMid(obj.getMid());
                log.info("2, addUserMerchant success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(userMerchantResult);
            }

            log.info("3, addUserMerchant fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: addUserMerchant 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            boolean deleteResult = fbUserBaseService.delete(Condition.create().eq(FbUserBase.BASE_ID, param.getBaseId()));
            log.info("delete userbase deleteResult = {}, baseId = {}", deleteResult, param.getBaseId());
            return BizResponse.serverError();
        }

    }


    @Override
    public BizResponse<Boolean> updateUserMerchant(UserMerchantParam param) {
        log.info("1, updateUserMerchant execute >> para={}", JSON.toJSONString(param));
        long mid = param.getMid();
        try {

            FbUserMerchant obj = new FbUserMerchant();
            BeanUtils.copyProperties(param, obj);

            boolean updateResult = fbUserMerchantService.update(obj, Condition.create().eq(FbUserMerchant.MID, mid));

            if (updateResult) {
                log.info("2, updateUserMerchant success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, updateUserMerchant fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: updateUserMerchant 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<MerchantDetailDTO> queryUserMerchantByMid(Long mid) {

        /*merchantDetailDTO  包含用户基础信息  和 商户信息*/
        MerchantDetailDTO merchantDetailDTO = new MerchantDetailDTO();


        FbUserMerchant fbUserMerchant = fbUserMerchantService.selectOne(Condition.create().eq(FbUserMerchant.MID, mid));
        MerchantInfo merchantInfo = BijectionUtils.invert(fbUserMerchant, MerchantInfo.class);

        if (merchantInfo != null) {
            FbUserBase fbUserBase = fbUserBaseService.selectOne(Condition.create().eq(FbUserBase.BASE_ID, merchantInfo.getBaseId()));
            BaseInfo baseInfo = BijectionUtils.invert(fbUserBase, BaseInfo.class);
            merchantDetailDTO.setBaseInfo(baseInfo);
        }

        merchantDetailDTO.setMerchantInfo(merchantInfo);

        return BizResponse.success(merchantDetailDTO);
    }

    @Override
    public BizResponse<PageResult<UserMerchantDTO>> queryUserMerchantPage(MerchantQuery merchantQuery) {

        Map map = BeanUtil.beanToMap(merchantQuery);

        int startNum = (merchantQuery.getPage() - 1) * merchantQuery.getPageSize();

        map.put("expire", merchantQuery.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        map.put("startNum", startNum);

        List<Map<String, Object>> list = fbUserMerchantMapper.queryUserMerchantPage(map);

        int totalNum = fbUserMerchantMapper.countUserMerchantByCondition(map);

        List<UserMerchantDTO> targetList = BijectionUtils.mapsToObjects(list, UserMerchantDTO.class);


        PageResult<UserMerchantDTO> pageResult = new PageResult(totalNum, targetList);

        return BizResponse.success(pageResult);
    }

    @Override
    public BizResponse<List<UserMerchantDTO>> queryUserMerchantListByCondition(MerchantQuery merchantQuery) {

        Map map = BeanUtil.beanToMap(merchantQuery);

        map.put("expire", merchantQuery.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        List<Map<String, Object>> list = fbUserMerchantMapper.queryUserMerchantListByCondition(map);

        List<UserMerchantDTO> targetList = BijectionUtils.mapsToObjects(list, UserMerchantDTO.class);

        return BizResponse.success(targetList);
    }


    /**
     * @author: spafka@github.com
     * @desc: 代理商条件搜索商户列表
     * @date: created on 2017-12-25 11:15:25.228
     */
    @Override
    public BizResponse<List<MerchantListSeachByAgentResult>> findMerchantListByAgent(MerchantQueryByAgentParam param) {



        Map map = BeanUtil.beanToMap(param);

        map.put("expire", param.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        log.debug(" findMerchantListByAgent param ={}",map);

        List< Map<String, Object>> stringObjectMap = fbUserMerchantMapper.queryUserMerchantPageByAgent(map);

        List<MerchantListSeachByAgentResult> merchantListSeachByAgentResults = BijectionUtils.mapsToObjects(stringObjectMap, MerchantListSeachByAgentResult.class);

        return  BizResponse.success(merchantListSeachByAgentResults);

    }

    @Override
    public BizResponse<List<MerchantListSeachByAgentResult>> findMerchantListByGrand(MerchantQueryByGradndParam param) {
        Map map = BeanUtil.beanToMap(param);

        map.put("expire", param.isExpire() ? IUserConstants.YES : IUserConstants.NO);

        log.debug(" findMerchantListByAgent param ={}",map);

        List< Map<String, Object>> stringObjectMap = fbUserMerchantMapper.queryUserMerchantPageByGrand(map);

        List<MerchantListSeachByAgentResult> merchantListSeachByAgentResults = BijectionUtils.mapsToObjects(stringObjectMap, MerchantListSeachByAgentResult.class);

        return  BizResponse.success(merchantListSeachByAgentResults);
    }
}
