/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.NodeParam;
import com.fshows.lifecircle.user.service.business.biz.INodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.dao.FbOemNodeRightMapper;
import com.fshows.lifecircle.user.service.dao.FbOemRoleNodeMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemNode;
import com.fshows.lifecircle.user.service.domain.po.FbOemRoleNode;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import com.fshows.lifecircle.user.service.domain.po.FbUserOemChildren;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-22 10:40
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class NodeServiceImpl implements INodeService {

  @Autowired
  private FbOemNodeRightMapper fbOemNodeRightMapper;
  @Autowired
  private IFbOemNodeService fbOemNodeService;
  @Autowired
  private FbOemRoleNodeMapper fbOemRoleNodeMapper;
  @Autowired
  private IFbUserBaseService fbUserBaseService;
  @Autowired
  private IFbUserOemService fbUserOemService;
  @Autowired
  private IFbUserOemChildrenService fbUserOemChildrenService;


  @Override
  public List<NodeParam> getNodeTreeByUserId(Long userId) {

    FbUserBase userBase = fbUserBaseService
        .selectOne(new EntityWrapper<FbUserBase>().eq(FbUserBase.BASE_ID, userId));

    Integer userType = userBase.getUserType();
    Integer isChild = userBase.getIsChild();

    // oem 主账号
    if (userType == 1 && isChild == 0) {

      FbUserOem fbUserOem = fbUserOemService
          .selectOne(new EntityWrapper<FbUserOem>().eq(FbUserOem.BASE_ID, userId));
      return getNodeTreeByOemIdOrRoleId(fbUserOem.getOemId(), null);

      // oem 子账号
    } else if (userType == 1 && isChild == 1) {

      FbUserOemChildren fbUserOemChildren = fbUserOemChildrenService
          .selectOne(new EntityWrapper<FbUserOemChildren>().eq(FbUserOemChildren.BASE_ID, userId));
      return getNodeTreeByOemIdOrRoleId(null, fbUserOemChildren.getRoleId());
    } else {

      return null;
    }
  }

  /**
   * 添加修改节点
   */
  @Override
  public Boolean addAndUpdateRoleNode(List<Long> nodeIds, Long roleId) {

    // 获得已经有数据库节点 id
    List<Long> dbNodeList = fbOemRoleNodeMapper.findNodeId(roleId);

    // 获得新增的 在参数不在数据库
    List<Long> addList = nodeIds.stream().filter(node -> !dbNodeList.contains(node))
        .collect(Collectors.toList());

    // 添加
    if (addList != null) {

      for (Long aLong : addList) {

        fbOemRoleNodeMapper.insert(new FbOemRoleNode().setNodeId(aLong).setRoleId(roleId));
      }
    }

    // 获得要删除的 在数据不在参数
    List<Long> delList = dbNodeList.stream().filter(node -> !nodeIds.contains(node))
        .collect(Collectors.toList());

    // 删除
    if (delList != null) {

      for (Long aLong : delList) {

        fbOemRoleNodeMapper.update(new FbOemRoleNode().setIsDel(1),
            new EntityWrapper<FbOemRoleNode>().eq(FbOemRoleNode.ROLE_ID, roleId)
                .eq(FbOemRoleNode.NODE_ID, aLong).eq(FbOemRoleNode.IS_DEL, 0));
      }
    }

    return true;
  }

  @Override
  public List<NodeParam> getNodeTreeByOemIdOrRoleId(Long oemId, Long roleId) {

    List<Long> hasNodeIds = null;
    // 获得 oem 拥有的 node 列表
    if (oemId != null) {

      hasNodeIds = fbOemNodeRightMapper.findNodeId(oemId);
    } else {

      hasNodeIds = fbOemRoleNodeMapper.findNodeId(roleId);
    }

    return getNodeTree(hasNodeIds);
  }

  @Override
  public List<NodeParam> getNodeTree(List<Long> hasNodeIds) {
    // 获得 oem 所有结点树
    List<FbOemNode> oemList = fbOemNodeService
        .selectList(new EntityWrapper<FbOemNode>().eq(FbOemNode.IS_DEL, 0));

    // 转换对象list
    List<NodeParam> nodeList = oemList.stream()
        .map(fbOemNode -> new NodeParam().setNodeId(fbOemNode.getNodeId())
            .setNodeName(fbOemNode.getTitle()).setPid(fbOemNode.getPid())
            .setAction(fbOemNode.getAction())
            .setIsCheck(hasNodeIds.contains(fbOemNode.getNodeId()))).collect(
            Collectors.toList());

    // 按 pid 分级
    Map<Long, List<NodeParam>> gropuByPidList = nodeList.stream()
        .collect(Collectors.groupingBy(NodeParam::getPid));

    // 添加子节点
    for (NodeParam nodeParam : nodeList) {

      nodeParam.setChildren(gropuByPidList.get(nodeParam.getNodeId()));
    }

    return nodeList.stream().filter(nodeParam -> nodeParam.getPid() == 0)
        .collect(Collectors.toList());



  }
}
