/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightControlDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbAgentRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbAgentRightControlService;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantRightControlService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightControlService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRightConfigServiceImpl
implements IUserRightConfigService {
    private static final Logger log = LoggerFactory.getLogger(UserRightConfigServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IUserBaseService userBaseService;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;
    @Autowired
    private IFbMerchantRightConfigService fbMerchantRightConfigService;
    @Autowired
    private IFbAgentRightConfigService fbAgentRightConfigService;
    @Autowired
    private IFbOemRightConfigService fbOemRightConfigService;
    @Autowired
    private IFbMerchantRightControlService fbMerchantRightControlService;
    @Autowired
    private IFbAgentRightControlService fbAgentRightControlService;
    @Autowired
    private IFbOemRightControlService fbOemRightControlService;

    @Override
    public BizResponse<List<RightConfigDTO>> queryUserRightConfigList(UserType type) {
        List list;
        List<Object> rightConfigList = new ArrayList();
        if (type == UserType.OEM) {
            list = this.fbOemRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list, RightConfigDTO.class);
        }
        if (type == UserType.AGENT || type == UserType.GRANT) {
            list = this.fbAgentRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list, RightConfigDTO.class);
        }
        if (type == UserType.MERCHANT) {
            list = this.fbMerchantRightConfigService.selectList(null);
            rightConfigList = BijectionUtils.invertList(list, RightConfigDTO.class);
        }
        return BizResponse.success(rightConfigList);
    }

    @Override
    public BizResponse<List<RightControlDTO>> queryUserRightControlList(UserType type, long userId) {
        List list;
        List<Object> controlList = new ArrayList();
        if (type == UserType.OEM) {
            list = this.fbOemRightControlService.selectList(Condition.create().eq("oem_id", (Object)userId));
            controlList = BijectionUtils.invertList(list, RightControlDTO.class);
        }
        if (type == UserType.AGENT || type == UserType.GRANT) {
            list = this.fbAgentRightControlService.selectList(Condition.create().eq("agent_id", (Object)userId));
            controlList = BijectionUtils.invertList(list, RightControlDTO.class);
        }
        if (type == UserType.MERCHANT) {
            list = this.fbMerchantRightControlService.selectList(Condition.create().eq("mid", (Object)userId));
            controlList = BijectionUtils.invertList(list, RightControlDTO.class);
        }
        return BizResponse.success(controlList);
    }
}

