/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryPageParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.RoleResult;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRoleService;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.domain.po.FbOemRole;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-18 14:02
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class RoleServiceImpl implements IRoleService {

  @Autowired
  private IFbOemRoleService fbOemRoleService;

  /**
   * 角色列表接口
   */
  @Override
  public PageResult<RoleResult> findRoleListByPage(RoleQueryPageParam roleQueryPageParam) {

    Page<FbOemRole> fbOemRolePage = fbOemRoleService.selectPage(new Page<FbOemRole>(),
        new EntityWrapper<FbOemRole>().eq(FbOemRole.OEM_ID, roleQueryPageParam.getOemId())
            .eq(FbOemRole.IS_DEL, 0));

    if (fbOemRolePage != null) {

      return new PageResult<RoleResult>(fbOemRolePage.getTotal(),
          fbOemRolePage.getRecords().stream().map(
              oemRole -> new RoleResult().setRemark(oemRole.getRemark())
                  .setRoleId(oemRole.getRoleId()).setRoleName(oemRole.getName())
                  .setStatus(oemRole.getStatus())).collect(
              Collectors.toList()));
    } else {

      return null;
    }
  }

  /**
   * 添加或修改角色
   */
  @Override
  public Boolean addOrUpdate(RoleAddOrUpdateParam param) {

    // 添加
    if (param.getRoleId() == null) {

      return fbOemRoleService.insert(
          new FbOemRole().setName(param.getRoleName()).setRemark(param.getRemark())
              .setOemId(param.getOemId()).setRoleId(KeyGenerator.getKeyByType()));

      // 修改
    } else {

      return fbOemRoleService
          .update(new FbOemRole().setName(param.getRoleName()).setRemark(param.getRemark())
                  .setStatus(param.getStatus()).setIsDel(param.getIsDel()),
              new EntityWrapper<FbOemRole>().eq(FbOemRole.ROLE_ID, param.getRoleId()));
    }
  }

  /**
   * 查询角色
   */
  @Override
  public RoleResult queryRole(RoleQueryParam param) {

    FbOemRole oemRole = fbOemRoleService.selectOne(
        new EntityWrapper<FbOemRole>().eq(FbOemRole.ROLE_ID, param.getRoleId())
            .eq(FbOemRole.OEM_ID, param.getOemId()).eq(FbOemRole.IS_DEL, 0));

    if (oemRole != null){

      return new RoleResult().setRemark(oemRole.getRemark())
          .setRoleId(oemRole.getRoleId()).setRoleName(oemRole.getName())
          .setStatus(oemRole.getStatus());
    }
    return null;
  }
}
