/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.user.service.business.utils;

import static java.util.stream.Collectors.toList;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.beans.BeanCopier;


/**
 * package: com.fshows.lifecircle.user.service.business.utils
 *
 * @author:spafka
 * @description: 目前只能使用spring的beanUtils，对于非标准的Bean的copy，其他的都会有问题
 * @date: created in 2017-12-18 13:41:39
 */
public class BijectionUtils {


  public static final <T> T mapToObject(Map<String, Object> map, Class<T> clazz) {

    if (null == map) {
      return null;
    }

    T t = null;

    try {
      t = clazz.newInstance();
      org.apache.commons.beanutils.BeanUtils.populate(t, map);

    } catch (Exception e) {
      throw new RuntimeException(e);
    }
    return t;

  }


  public static final <T> List<T> mapsToObjects(List<Map<String, Object>> from, Class<T> clazz) {

    if (null == from) {
      return null;
    }
    List<T> collect = from
        .stream()
        .map(x -> {
          T t = null;

          try {
            t = clazz.newInstance();
            org.apache.commons.beanutils.BeanUtils.populate(t, x);

          } catch (Exception e) {
            throw new RuntimeException(e);
          }

          return t;
        }).collect(toList());
    return collect;

  }


  public static final <T> List<T> invertList(Collection from, Class<T> clazz) {

    if (null == from) {
      return null;
    }

    List<T> collect = (List<T>) from
        .stream()
        .map(x -> {
          T t = null;
          try {
            t = clazz.newInstance();
          } catch (InstantiationException e) {
            throw new RuntimeException(
                String.format("%s must have an none argumernts Constructor ", clazz.getName()));
          } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
          }
          BeanUtils.copyProperties(x, t);
          return t;
        }).collect(toList());
    return collect;

  }


  public static final <T> T invert(Object from, Class<T> clazz) {

    if (null == from) {
      return null;
    }

    if (from instanceof Collection) {
      throw new RuntimeException(String.format(
          "from.runTime class is %s and  it is instanceof Collection, maybe use invertList instead",
          from.getClass()));
    }

    T t = null;
    try {
      t = clazz.newInstance();
    } catch (InstantiationException e) {
      throw new RuntimeException(
          String.format("%s must have an none argumernts Constructor ", clazz.getName()));
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    }

    BeanUtils.copyProperties(from, t);

    return t;
  }

  public static final <T> T invert(Object from, T t) {

    if (null == from) {
      return t;
    }

    if (from instanceof Collection) {
      throw new RuntimeException(String.format(
          "from.runTime class is %s and  it is instanceof Collection, maybe use invertList instead",
          from.getClass()));
    }

    BeanUtils.copyProperties(from, t);

    return t;

  }

  public static Map<String, BeanCopier> beanCopierCache = new ConcurrentHashMap<>();


}
