/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginConfigResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.ILoginService;
import com.fshows.lifecircle.user.service.business.db.IFbOemConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.UserTypeEnum;
import com.fshows.lifecircle.user.service.domain.po.FbOemConfig;
import com.fshows.lifecircle.user.service.domain.po.FbUserAgent;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.util.NetUtil;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements ILoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbOemConfigService fbOemConfigService;

    @Override
    public BizResponse<LoginResult> login(LoginParam loginParam) {
        FbUserAgent userAgent;
        FbUserBase userBase = (FbUserBase)this.fbUserBaseService.selectOne(new EntityWrapper().eq("username", (Object)loginParam.getUsername()).eq("is_del", (Object)0));
        if (userBase == null) {
            return BizResponse.fail((String)ErrorCodeEnum.USERNAME_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USERNAME_NOT_EXIST.getMsg());
        }
        if (userBase.getStatus() != 1) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_DISABLE.getCode(), (String)ErrorCodeEnum.USER_DISABLE.getMsg());
        }
        Integer userType = loginParam.getUserType();
        if (!userBase.getUserType().equals(userType)) {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        LoginResult loginResult = new LoginResult();
        loginResult.setUserId(userBase.getBaseId());
        loginResult.setOemId(loginParam.getOemId());
        loginResult.setChild(Boolean.valueOf(userBase.getIsChild() == 1));
        loginResult.setUserType(userType);
        UserTypeEnum userTypeEnum = UserTypeEnum.valueOf(userType);
        if (UserTypeEnum.OEM.equals((Object)userTypeEnum)) {
            FbUserOem userOem = (FbUserOem)this.fbUserOemService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
            if (userOem == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
            loginResult.setSelf(Boolean.valueOf(userOem.getIsSelfSupport() == 1));
        } else if (UserTypeEnum.AGENT.equals((Object)userTypeEnum)) {
            userAgent = (FbUserAgent)this.fbUserAgentService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
            if (userAgent == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
        } else if (UserTypeEnum.GRANT.equals((Object)userTypeEnum)) {
            userAgent = (FbUserAgent)this.fbUserAgentService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
            if (userAgent == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
            loginResult.setAgentId(userAgent.getBelong());
        } else if (UserTypeEnum.MERCHANT.equals((Object)userTypeEnum)) {
            FbUserMerchant userMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(new EntityWrapper().eq("base_id", (Object)userBase.getBaseId()));
            if (userMerchant == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
            Long agentId = userMerchant.getAgentId();
            FbUserAgent userAgent2 = (FbUserAgent)this.fbUserAgentService.selectOne(new EntityWrapper().eq("base_id", (Object)agentId));
            if (userAgent2 == null) {
                return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
            }
            Long belong = userAgent2.getBelong();
            if (belong != 0L) {
                loginResult.setAgentId(belong);
                loginResult.setGrantId(agentId);
            } else {
                loginResult.setAgentId(agentId);
            }
        } else {
            return BizResponse.fail((String)ErrorCodeEnum.USERTYPE_ERROR.getCode(), (String)ErrorCodeEnum.USERTYPE_ERROR.getMsg());
        }
        String requestPwdByMd5 = SecureUtil.md5((String)(loginParam.getPassword() + userBase.getSalt()));
        if (!requestPwdByMd5.equals(userBase.getUserpwd())) {
            return BizResponse.fail((String)ErrorCodeEnum.PASSWORD_ERROR.getCode(), (String)ErrorCodeEnum.PASSWORD_ERROR.getMsg());
        }
        boolean update = false;
        try {
            update = this.fbUserBaseService.update(new FbUserBase().setLastLoginIp(Long.valueOf(NetUtil.ipv4ToLong((String)loginParam.getLoginIp()))).setLastLoginTime(new Date()), new EntityWrapper().eq("username", (Object)loginParam.getUsername()));
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: login \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: loginParam = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)loginParam), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return BizResponse.success((Object)loginResult);
    }

    @Override
    public BizResponse<LoginConfigResult> getLoginConf(LoginConfigParam loginConfigParam) {
        Integer configType = loginConfigParam.getConfigType();
        String oemShortName = loginConfigParam.getOemShortName();
        FbOemConfig oemConfig = (FbOemConfig)this.fbOemConfigService.selectOne(new EntityWrapper().eq("sub_domain", (Object)oemShortName));
        if (oemConfig == null) {
            return BizResponse.fail((String)ErrorCodeEnum.NO_HAVE_LOGIN_CONFIG.getCode(), (String)ErrorCodeEnum.NO_HAVE_LOGIN_CONFIG.getMsg());
        }
        LoginConfigResult loginConfigResult = new LoginConfigResult();
        loginConfigResult.setLogoutUrl(oemConfig.getSubDomain());
        if (configType.equals(UserTypeEnum.OEM.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getAdminLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getAdminLoginLogo());
            loginConfigResult.setTitle(oemConfig.getAdminLoginTitle());
            loginConfigResult.setLogo(oemConfig.getAdminLogo());
        } else if (configType.equals(UserTypeEnum.AGENT.getValue()) || configType.equals(UserTypeEnum.GRANT.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getAgentLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getAgentLoginLogo());
            loginConfigResult.setLogo(oemConfig.getAgentLogo());
            loginConfigResult.setTitle(oemConfig.getAgentLoginTitle());
        } else if (configType.equals(UserTypeEnum.MERCHANT.getValue())) {
            loginConfigResult.setLoginBg(oemConfig.getUserLoginBg());
            loginConfigResult.setLoginLogo(oemConfig.getUserLoginLogo());
            loginConfigResult.setLogo(oemConfig.getUserLogo());
            loginConfigResult.setTitle(oemConfig.getUserLoginTitle());
        }
        return BizResponse.success((Object)loginConfigResult);
    }
}

