/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantChildrenRoleParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantChildrenService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildren;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchantChildrenRole;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.impl.biz
 * 功能：
 * 创建时间：2017-12-15 10:31
 * 更新记录：
 *
 * @author caofy
 */
@Slf4j
@Service
public class UserMerchantChildrenServiceImpl implements IUserMerchantChildrenService {

    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IFbUserMerchantChildrenService fbUserMerchantChildrenService;
    @Autowired
    private IFbUserMerchantChildrenRoleService fbUserMerchantChildrenRoleService;

    @Autowired
    private IUserBaseService userBaseService;

    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;


    @Override
    public BizResponse<Boolean> addUserMerchantChildren(UserMerchantChildrenParam param) {
        log.info("1, addUserMerchantChildren execute >> para={}", JSON.toJSONString(param));
        try {

            FbUserMerchantChildren obj = new FbUserMerchantChildren();
            BeanUtils.copyProperties(param, obj);

            boolean addResult = fbUserMerchantChildrenService.insert(obj);

            if (addResult) {
                log.info("2, addUserMerchantChildren success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, addUserMerchantChildren fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: addUserMerchantChildren 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<Boolean> addUserMerchantChildrenRole(UserMerchantChildrenRoleParam param) {
        log.info("1, addUserMerchantChildrenRole execute >> para={}", JSON.toJSONString(param));
        try {

            FbUserMerchantChildrenRole obj = new FbUserMerchantChildrenRole();
            BeanUtils.copyProperties(param, obj);

            boolean addResult = fbUserMerchantChildrenRoleService.insert(obj);

            if (addResult) {
                log.info("2, addUserMerchantChildrenRole success >> para={}", JSON.toJSONString(param));

                return BizResponse.success(Boolean.TRUE);
            }

            log.info("3, addUserMerchantChildrenRole fail >> para={}", JSON.toJSONString(param));

            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(),ErrorCodeEnum.INVALID_PARAMETER.getMsg());

        } catch (Exception e) {
            log.error("方法: addUserMerchantChildrenRole 发生异常， 参数: param = {} ,异常: Ex = {}", JSON.toJSONString(param),
                    ExceptionUtils.getStackTrace(e));
            return BizResponse.serverError();
        }
    }
}
