/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.user.service.business.impl.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LogParam;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.ILogService;
import com.fshows.lifecircle.user.service.business.db.IFbOperateLogService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.domain.po.FbOperateLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl implements ILogService {

    @Autowired
    IFbOperateLogService operateLogService;

    @Override
    public BizResponse<Boolean> saveLog(LogParam param) {


        FbOperateLog operateLog = BijectionUtils.invert(param, FbOperateLog.class);

        return BizResponse.success(operateLogService.insert(operateLog));
    }
}
