/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-12 16:30
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.UserBaseResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-15 10:30
 * 更新记录：
 * @author BuHao
 */
public interface IUserBaseService {

  /**
   * 添加基础用户信息
   * @param userBaseParam
   * @return
   */
  BizResponse<UserBaseResult> addUserBase(UserBaseParam userBaseParam);


  /**
   * 修改基础用户信息
   * @param userBaseParam
   * @return
   */
  BizResponse<Boolean> updateUserBase(UserBaseParam userBaseParam);

  /**
   * 删除基础用户信息 逻辑删除
   * @param baseId
   * @return
   */
  BizResponse<Boolean> deleteUserBase(Long baseId);


  /**
   * 根据username查询
   * @param username
   * @return
   */
  BizResponse<BaseInfo> getUserBaseByUsername(String username);

  /**
   * 根据ubaseId查询
   * @param baseId
   * @return
   */
  BizResponse<BaseInfo> getUserBaseByBaseId(Long baseId);
}
