/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-22 10:34
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.user.service.business.biz;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.NodeParam;
import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.biz
 * 功能：
 * 创建时间：2017-12-22 10:34
 * 更新记录：
 * @author BuHao
 */
public interface INodeService {

  /**
   * 根据 id 获得节点树
   * @param oemId
   * @param roleId
   * @return
   */
  List<NodeParam> getNodeTreeByOemIdOrRoleId(Long oemId, Long roleId);

  /**
   * 获得节点树
   * @param hasNodeIds
   * @return
   */
  List<NodeParam> getNodeTree(List<Long> hasNodeIds);

  /**
   * 通过 userId 获得节点树
   * @param userId
   * @return
   */
  List<NodeParam> getNodeTreeByUserId(Long userId);

  /**
   * 添加修改节点
   * @param nodeIds
   * @param roleId
   * @return
   */
  Boolean addAndUpdateRoleNode(List<Long> nodeIds, Long roleId);
}
