/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightControlService;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.dao.FbOemRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserOemMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbOemRightControlServiceImpl
extends ServiceImpl<FbOemRightControlMapper, FbOemRightControl>
implements IFbOemRightControlService {
    private static final Logger log = LoggerFactory.getLogger(FbOemRightControlServiceImpl.class);
    @Autowired
    private FbOemRightControlMapper fbOemRightControlMapper;
    @Autowired
    private FbUserOemMapper fbUserOemMapper;

    @Override
    public BizResponse<Boolean> updateOemRightControl(Long userId, String[] array) {
        log.info("updateOemRightControl execute >> userId={}, array = {}", (Object)userId, (Object)array);
        try {
            FbUserOem fbUserOem = new FbUserOem();
            fbUserOem.setOemId(userId);
            fbUserOem = (FbUserOem)this.fbUserOemMapper.selectOne((Object)fbUserOem);
            if (userId == null || array == null || fbUserOem == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            List fbOemRightControlList = this.fbOemRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateUserRightControl \u5b58\u50a8\u5386\u53f2\u6570\u636e fbAgentRightControlList = {}", (Object)JSON.toJSONString((Object)fbOemRightControlList));
            if (fbOemRightControlList.size() > 0) {
                this.fbOemRightControlMapper.deleteByUserId(userId);
            }
            Integer i = 0;
            for (String s : array) {
                FbOemRightControl fbOemRightControl = new FbOemRightControl();
                long businessUniqId = KeyGenerator.getKeyByType();
                fbOemRightControl.setId(Long.valueOf(businessUniqId));
                fbOemRightControl.setOemId(userId);
                fbOemRightControl.setRightKey(s);
                fbOemRightControl.setIsOpen(Integer.valueOf(1));
                fbOemRightControl.setCreateTime(new Date());
                fbOemRightControl.setUpdateTime(new Date());
                Integer addResultCount = this.fbOemRightControlMapper.insert((Object)fbOemRightControl);
                i = i + addResultCount;
            }
            if (i != array.length) {
                this.fbOemRightControlMapper.deleteByUserId(userId);
                if (fbOemRightControlList != null && fbOemRightControlList.size() > 0) {
                    for (FbOemRightControl control : fbOemRightControlList) {
                        this.fbOemRightControlMapper.insert((Object)control);
                    }
                }
                return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }
            return BizResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("2.3.9 - 3, \u65b9\u6cd5: updateOemRightControl \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userId = {}, array = {},\u5f02\u5e38: Ex = {}", new Object[]{userId, array, ExceptionUtils.getStackTrace((Throwable)e)});
            return BizResponse.serverError();
        }
    }
}

