/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.db.IFbMerchantRightControlService;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.dao.FbMerchantRightControlMapper;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbMerchantRightControl;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbMerchantRightControlServiceImpl
extends ServiceImpl<FbMerchantRightControlMapper, FbMerchantRightControl>
implements IFbMerchantRightControlService {
    private static final Logger log = LoggerFactory.getLogger(FbMerchantRightControlServiceImpl.class);
    @Autowired
    private FbMerchantRightControlMapper fbMerchantRightControlMapper;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public BizResponse<Boolean> updateMerchantRightControl(Long userId, String[] array) {
        log.info("updateMerchantRightControl execute >> userId={}, array = {}", (Object)userId, (Object)array);
        try {
            FbUserMerchant fbUserMerchant = new FbUserMerchant();
            fbUserMerchant.setMid(userId);
            fbUserMerchant = (FbUserMerchant)this.fbUserMerchantMapper.selectOne((Object)fbUserMerchant);
            if (userId == null || array == null || fbUserMerchant == null) {
                log.info("2.3.9 - 1, updateOemRightControl check fail, userId or array can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            List fbMerchantRightControlList = this.fbMerchantRightControlMapper.selectCountByUserId(userId);
            log.info("2.3.9 - 2, updateMerchantRightControl \u5b58\u50a8\u5386\u53f2\u6570\u636e fbAgentRightControlList = {}", (Object)JSON.toJSONString((Object)fbMerchantRightControlList));
            if (fbMerchantRightControlList.size() > 0) {
                this.fbMerchantRightControlMapper.deleteByUserId(userId);
            }
            Integer i = 0;
            for (String s : array) {
                FbMerchantRightControl fbMerchantRightControl = new FbMerchantRightControl();
                long businessUniqId = KeyGenerator.getKeyByType();
                fbMerchantRightControl.setId(Long.valueOf(businessUniqId));
                fbMerchantRightControl.setMid(userId);
                fbMerchantRightControl.setRightKey(s);
                fbMerchantRightControl.setIsOpen(Integer.valueOf(1));
                fbMerchantRightControl.setCreateTime(new Date());
                fbMerchantRightControl.setUpdateTime(new Date());
                Integer addResultCount = this.fbMerchantRightControlMapper.insert((Object)fbMerchantRightControl);
                i = i + addResultCount;
            }
            if (i != array.length) {
                this.fbMerchantRightControlMapper.deleteByUserId(userId);
                if (fbMerchantRightControlList != null && fbMerchantRightControlList.size() > 0) {
                    for (FbMerchantRightControl control : fbMerchantRightControlList) {
                        this.fbMerchantRightControlMapper.insert((Object)control);
                    }
                }
                return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
            }
            return BizResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("2.3.9 - 3, \u65b9\u6cd5: updateMerchantRightControl \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: userId = {}, array = {},\u5f02\u5e38: Ex = {}", new Object[]{userId, array, ExceptionUtils.getStackTrace((Throwable)e)});
            return BizResponse.serverError();
        }
    }
}

