/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryPageParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.RoleResult;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IRoleService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRoleService;
import com.fshows.lifecircle.user.service.domain.po.FbOemRole;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements IRoleService {
    @Autowired
    private IFbOemRoleService fbOemRoleService;

    @Override
    public PageResult<RoleResult> findRoleListByPage(RoleQueryPageParam roleQueryPageParam) {
        Page fbOemRolePage = this.fbOemRoleService.selectPage(new Page(), new EntityWrapper().eq("oem_id", (Object)roleQueryPageParam.getOemId()).eq("is_del", (Object)0));
        if (fbOemRolePage != null) {
            return new PageResult(Integer.valueOf(fbOemRolePage.getTotal()), fbOemRolePage.getRecords().stream().map(oemRole -> new RoleResult().setRemark(oemRole.getRemark()).setRoleId(oemRole.getRoleId()).setRoleName(oemRole.getName()).setStatus(oemRole.getStatus())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public Boolean addOrUpdate(RoleAddOrUpdateParam param) {
        if (param.getRoleId() == null) {
            return this.fbOemRoleService.insert(new FbOemRole().setName(param.getRoleName()).setRemark(param.getRemark()).setOemId(param.getOemId()));
        }
        return this.fbOemRoleService.update(new FbOemRole().setName(param.getRoleName()).setRemark(param.getRemark()).setStatus(param.getStatus()).setIsDel(param.getIsDel()), new EntityWrapper().eq("role_id", (Object)param.getRoleId()));
    }

    @Override
    public RoleResult queryRole(RoleQueryParam param) {
        FbOemRole oemRole = (FbOemRole)this.fbOemRoleService.selectOne(new EntityWrapper().eq("role_id", (Object)param.getRoleId()).eq("oem_id", (Object)param.getOemId()).eq("is_del", (Object)0));
        if (oemRole != null) {
            return new RoleResult().setRemark(oemRole.getRemark()).setRoleId(oemRole.getRoleId()).setRoleName(oemRole.getName()).setStatus(oemRole.getStatus());
        }
        return null;
    }
}

