/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.Condition;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantDetailDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantInfo;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantQuery;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMerchantResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.userbase.BaseInfo;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;
import com.fshows.lifecircle.user.service.business.biz.IUserBaseService;
import com.fshows.lifecircle.user.service.business.biz.IUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserAgentService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserMerchantService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.dao.FbUserMerchantMapper;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserMerchant;
import com.xiaoleilu.hutool.util.BeanUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserMerchantServiceImpl
implements IUserMerchantService {
    private static final Logger log = LoggerFactory.getLogger(UserMerchantServiceImpl.class);
    @Autowired
    private IFbUserBaseService fbUserBaseService;
    @Autowired
    private IFbUserOemService fbUserOemService;
    @Autowired
    private IFbUserAgentService fbUserAgentService;
    @Autowired
    private IFbUserMerchantService fbUserMerchantService;
    @Autowired
    private IUserBaseService userBaseService;
    @Autowired
    private FbUserMerchantMapper fbUserMerchantMapper;

    @Override
    public BizResponse<UserMerchantResult> addUserMerchant(UserMerchantParam param) {
        UserMerchantResult userMerchantResult = new UserMerchantResult();
        log.info("1, addUserMerchant execute >> para={}", (Object)JSON.toJSONString((Object)param));
        try {
            if (param.getBaseId() == null || param.getOemId() == null) {
                log.info("1.1, addUserMerchant check fail, baseId or oemId can not be null");
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            FbUserMerchant obj = new FbUserMerchant();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            long businessUniqId = KeyGenerator.getKeyByType();
            obj.setMid(Long.valueOf(businessUniqId));
            obj.setStatus(Integer.valueOf(0));
            boolean addResult = this.fbUserMerchantService.insert(obj);
            if (addResult) {
                userMerchantResult.setMid(obj.getMid());
                log.info("2, addUserMerchant success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)userMerchantResult);
            }
            log.info("3, addUserMerchant fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: addUserMerchant \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: param = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<Boolean> modifyUserMerchant(UserMerchantParam param) {
        log.info("1, modifyUserMerchant execute >> para={}", (Object)JSON.toJSONString((Object)param));
        long mid = param.getMid();
        log.info("1, modifyUserMerchant execute >> mid={}", (Object)mid);
        try {
            FbUserMerchant obj = new FbUserMerchant();
            BeanUtils.copyProperties((Object)param, (Object)obj);
            boolean updateResult = this.fbUserMerchantService.update(obj, Condition.create().eq("mid", (Object)mid));
            if (updateResult) {
                log.info("2, modifyUserMerchant success >> para={}", (Object)JSON.toJSONString((Object)param));
                return BizResponse.success((Object)Boolean.TRUE);
            }
            log.info("3, modifyUserMerchant fail >> para={}", (Object)JSON.toJSONString((Object)param));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        catch (Exception e) {
            log.error("\u65b9\u6cd5: modifyUserMerchant \u53d1\u751f\u5f02\u5e38\uff0c \u53c2\u6570: param = {} ,\u5f02\u5e38: Ex = {}", (Object)JSON.toJSONString((Object)param), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return BizResponse.serverError();
        }
    }

    @Override
    public BizResponse<MerchantDetailDTO> queryUserMerchantByMid(Long mid) {
        MerchantDetailDTO merchantDetailDTO = new MerchantDetailDTO();
        FbUserMerchant fbUserMerchant = (FbUserMerchant)this.fbUserMerchantService.selectOne(Condition.create().eq("mid", (Object)mid));
        MerchantInfo merchantInfo = (MerchantInfo)BijectionUtils.invert((Object)fbUserMerchant, MerchantInfo.class);
        FbUserBase fbUserBase = (FbUserBase)this.fbUserBaseService.selectOne(Condition.create().eq("base_id", (Object)mid));
        BaseInfo baseInfo = (BaseInfo)BijectionUtils.invert((Object)fbUserBase, BaseInfo.class);
        merchantDetailDTO.setMerchantInfo(merchantInfo);
        merchantDetailDTO.setBaseInfo(baseInfo);
        return BizResponse.success((Object)merchantDetailDTO);
    }

    @Override
    public BizResponse<PageResult<UserMerchantDTO>> queryUserMerchantPage(MerchantQuery merchantQuery) {
        Map map = BeanUtil.beanToMap((Object)merchantQuery);
        int startNum = (merchantQuery.getPage() - 1) * merchantQuery.getPageSize();
        map.put("expire", merchantQuery.isExpire() ? "yes" : "no");
        map.put("startNum", startNum);
        List list = this.fbUserMerchantMapper.queryUserMerchantPage(map);
        int totalNum = this.fbUserMerchantMapper.countUserMerchantByCondition(map);
        List<UserMerchantDTO> targetList = BijectionUtils.mapsToObjects(list, UserMerchantDTO.class);
        PageResult pageResult = new PageResult(Integer.valueOf(totalNum), targetList);
        return BizResponse.success((Object)pageResult);
    }
}

