/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.user.service.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemConfigParma;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemNodeParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemNodeRightParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.AddOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.GetOemWebConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.SearchOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemNodeParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.oem.UpdateOemParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons.ErrorCodeEnum;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.GetOemWebConfigResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeListDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemNodeRightDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemRightConfigDTO;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.SearchOemDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.user.service.business.biz.IOemService;
import com.fshows.lifecircle.user.service.business.db.IFbOemConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeRightService;
import com.fshows.lifecircle.user.service.business.db.IFbOemNodeService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightConfigService;
import com.fshows.lifecircle.user.service.business.db.IFbOemRightControlService;
import com.fshows.lifecircle.user.service.business.db.IFbUserBaseService;
import com.fshows.lifecircle.user.service.business.db.IFbUserOemService;
import com.fshows.lifecircle.user.service.business.utils.BijectionUtils;
import com.fshows.lifecircle.user.service.business.utils.KeyGenerator;
import com.fshows.lifecircle.user.service.business.utils.KeyTypeEnum;
import com.fshows.lifecircle.user.service.domain.po.FbOemConfig;
import com.fshows.lifecircle.user.service.domain.po.FbOemNode;
import com.fshows.lifecircle.user.service.domain.po.FbOemNodeRight;
import com.fshows.lifecircle.user.service.domain.po.FbUserBase;
import com.fshows.lifecircle.user.service.domain.po.FbUserOem;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OemServiceImpl
implements IOemService {
    private static final Logger log = LoggerFactory.getLogger(OemServiceImpl.class);
    @Autowired
    IFbUserOemService oemService;
    @Autowired
    IFbUserBaseService baseService;
    @Autowired
    IFbOemConfigService configService;
    @Autowired
    IFbOemNodeService nodeService;
    @Autowired
    IFbOemNodeRightService nodeRightService;
    @Autowired
    IFbOemRightConfigService oemRightConfigService;
    @Autowired
    IFbOemRightControlService oemRightControlService;

    @Override
    public BizResponse addOem(AddOemParam param) {
        if (null == param.getBaseId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        if (null == this.baseService.selectOne(new EntityWrapper().eq("base_id", (Object)param.getBaseId()))) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USER_NOT_EXIST.getMsg());
        }
        if (null != this.oemService.selectOne(new EntityWrapper().eq("base_id", (Object)param.getBaseId()))) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_HAS_EXIST.getCode(), (String)ErrorCodeEnum.USER_HAS_EXIST.getMsg());
        }
        FbUserOem fbUserOem = new FbUserOem();
        BeanUtils.copyProperties((Object)param, (Object)fbUserOem);
        fbUserOem.setOemId(KeyGenerator.getKeyByType(KeyTypeEnum.OEM_USER_KEY));
        boolean inserted = this.oemService.insert(fbUserOem);
        if (inserted) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse updateOem(UpdateOemParam param) {
        FbUserOem oem = null;
        if (null != param.getOemId()) {
            oem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("oem_id", (Object)param.getOemId()));
        }
        if (null == oem) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USER_NOT_EXIST.getMsg());
        }
        BijectionUtils.invert((Object)param, oem);
        oem.setUpdateTime(null);
        boolean updateEd = this.oemService.updateById(oem);
        if (updateEd) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
    }

    @Override
    public BizResponse addOemConfig(AddOemConfigParma param) {
        FbOemConfig oemConfig;
        boolean inserted;
        if (null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        if (null == param.getProtocolContent()) {
            param.setProtocolContent(" ");
        }
        if (inserted = this.configService.insert(oemConfig = (FbOemConfig)BijectionUtils.invert((Object)param, FbOemConfig.class))) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse updateOemConfig(UpdateOemConfigParam param) {
        if (null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbOemConfig oemConfig = (FbOemConfig)BijectionUtils.invert((Object)param, FbOemConfig.class);
        boolean inserted = this.configService.update(oemConfig, new EntityWrapper().eq("oem_id", (Object)param.getOemId()));
        if (inserted) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse getOemWebConfig(GetOemWebConfigParam config) {
        FbUserOem userOem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("brand_name", (Object)config));
        if (null == userOem) {
            return BizResponse.fail((String)ErrorCodeEnum.USER_NOT_EXIST.getCode(), (String)ErrorCodeEnum.USER_NOT_EXIST.getMsg());
        }
        Long oemId = userOem.getOemId();
        FbUserBase base = (FbUserBase)this.baseService.selectOne(new EntityWrapper().where("base_id={}", new Object[]{userOem.getBaseId()}));
        FbOemConfig oemConfig = (FbOemConfig)this.configService.selectById(oemId);
        if (null == oemConfig) {
            return BizResponse.fail((String)ErrorCodeEnum.OEM_CONFIG_NOT_EXIT.getCode(), (String)ErrorCodeEnum.OEM_CONFIG_NOT_EXIT.getMsg());
        }
        GetOemWebConfigResult webConfig = GetOemWebConfigResult.builder().oemId(oemId).oemName(base.getUsername()).oemSysLog(oemConfig.getAdminLogo()).oemFaviconLog(oemConfig.getWebLogo()).loginOutUrl(oemConfig.getAdminUrl()).build();
        return BizResponse.success((Object)webConfig);
    }

    @Override
    public BizResponse<List<SearchOemDTO>> searchOem(SearchOemParam param) {
        if (null == param.getPage()) {
            param.setPage(Integer.valueOf(1));
        }
        if (null == param.getPageSize()) {
            param.setPageSize(Integer.valueOf(20));
        }
        Page oemPagez = this.oemService.selectPage(new Page(param.getPage().intValue(), param.getPageSize().intValue()), new EntityWrapper().ge(null != param.getCreateTime(), "create_time", (Object)param.getCreateTime()).like(null != param.getOemName(), "brand_name", param.getOemName()).orderBy(null != param.getIsAsc(), "create_time", param.getIsAsc().booleanValue()));
        List<SearchOemDTO> records = BijectionUtils.invertList(oemPagez.getRecords(), SearchOemDTO.class);
        return BizResponse.success(records);
    }

    @Override
    public BizResponse getOemByOemId(String oemID) {
        if (null == oemID || 0 == oemID.length()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbUserOem userOem = (FbUserOem)this.oemService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemID));
        FbUserBase userBase = (FbUserBase)this.baseService.selectOne(new EntityWrapper().eq("base_id", (Object)userOem.getBaseId()));
        FbOemConfig oemConfig = (FbOemConfig)this.configService.selectOne(new EntityWrapper().eq("oem_id", (Object)oemID));
        OemResult oemResult = new OemResult();
        BijectionUtils.invert((Object)userOem, oemResult);
        BijectionUtils.invert((Object)oemConfig, oemResult);
        BijectionUtils.invert((Object)userBase, oemResult);
        return BizResponse.success((Object)oemResult);
    }

    @Override
    public BizResponse addOemNode(AddOemNodeParam param) {
        FbOemNode pNode;
        if (null != param.getPid() && param.getPid() != 0L && null == (pNode = (FbOemNode)this.nodeService.selectOne(new EntityWrapper().eq("node_id", (Object)param.getPid())))) {
            return BizResponse.fail((String)ErrorCodeEnum.NODE_NOT_EXIST.getCode(), (String)ErrorCodeEnum.NODE_NOT_EXIST.getMsg());
        }
        FbOemNode newNode = (FbOemNode)BijectionUtils.invert((Object)param, FbOemNode.class);
        newNode.setNodeId(KeyGenerator.getKeyByType());
        for (int j = 0; j <= 10 && null != this.nodeService.selectOne(new EntityWrapper().eq("node_id", (Object)newNode.getNodeId())); ++j) {
            newNode.setNodeId(KeyGenerator.getKeyByType());
        }
        boolean insertEd = this.nodeService.insert(newNode);
        if (insertEd) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse updateOemNode(UpdateOemNodeParam param) {
        FbOemNode node = (FbOemNode)this.nodeService.selectOne(new EntityWrapper().eq("node_id", (Object)param.getNodeId()));
        if (null == node) {
            return BizResponse.fail((String)ErrorCodeEnum.NODE_NOT_EXIST.getCode(), (String)ErrorCodeEnum.NODE_NOT_EXIST.getMsg());
        }
        FbOemNode invert = (FbOemNode)BijectionUtils.invert((Object)param, FbOemNode.class);
        boolean update = this.nodeService.update(invert, new EntityWrapper().eq("node_id", (Object)param.getNodeId()));
        if (update) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    @Override
    public BizResponse setOemNodeRight(AddOemNodeRightParam param) {
        if (null == param.getNodeId() || null == param.getOemId()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        FbOemNodeRight hasOne = (FbOemNodeRight)this.nodeRightService.selectOne(new EntityWrapper().eq("node_id", (Object)param.getNodeId()).eq("oem_id", (Object)param.getOemId()));
        if (null != hasOne) {
            return BizResponse.fail((String)ErrorCodeEnum.NODE_HAS_EXIST.getCode(), (String)ErrorCodeEnum.NODE_HAS_EXIST.getMsg());
        }
        FbOemNodeRight nodeRight = (FbOemNodeRight)BijectionUtils.invert((Object)param, FbOemNodeRight.class);
        boolean insert = this.nodeRightService.insert(nodeRight);
        if (insert) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
    }

    @Override
    public BizResponse<List<OemNodeListDTO>> getNodez() {
        List nodeList = this.nodeService.selectList(new EntityWrapper().orderBy("level", true).orderBy("sort", true).orderBy("pid", true));
        List<OemNodeListDTO> oemNodeLists = BijectionUtils.invertList(nodeList, OemNodeListDTO.class);
        return BizResponse.success(oemNodeLists);
    }

    @Override
    public BizResponse<List<OemNodeRightDTO>> getOemNodeRightz(long oemId) {
        List<Map<String, Object>> maps = this.nodeRightService.selectOemRights(oemId);
        List<OemNodeRightDTO> oemNodeRightDTOS = BijectionUtils.mapsToObjects(maps, OemNodeRightDTO.class);
        return BizResponse.success(oemNodeRightDTOS);
    }

    @Override
    public BizResponse<List<OemRightConfigDTO>> getAllOemRight() {
        List fbOemRightConfigs = this.oemRightConfigService.selectList(new EntityWrapper().eq("status", (Object)1));
        List<OemRightConfigDTO> rightDTOS = BijectionUtils.invertList(fbOemRightConfigs, OemRightConfigDTO.class);
        return BizResponse.success(rightDTOS);
    }

    @Override
    public BizResponse getOemNodezByTree(long oemId) {
        List<Map<String, Object>> maps = this.nodeRightService.selectOemRights(oemId);
        List<OemNodeRightDTO> oemNodeRightDTOS = BijectionUtils.mapsToObjects(maps, OemNodeRightDTO.class);
        return null;
    }
}

