package com.fshows.lifecircle.service.user.openapi.facade.domain.result;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MerchantAuthListResult {

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 身份证name
     */
    private String idname;
    /**
     * 商户Id
     */
    private Long mid;
    /**
     * 1：个人用户；2：企业
     */
    private Integer type;
    /**
     * 个人审核 身份证
     */
    private String idcard;
    /**
     * 审核状态 1认证中/待认证，2认证成功，3认证失败
     */
    private Integer authStatus;
    /**
     * 营业执照编号
     */
    private String licenseid;
    /**
     * 营业执照名称（公司名称）
     */
    private String licensename;
    /**
     * 代理商
     */
    private String company;
    /**
     * 商户名称
     */
    private String title;
    /**
     * 商户联系方式
     */
    private String contact;
    /**
     * 法人身份证
     */
    private String legalIdcard;
    /**
     * 法人名称
     */
    private String legalPerson;
}
