/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.result;

import lombok.Builder;
import lombok.Data;

import java.util.Date;

@Data
public class FbOperateLogResult {

    private Long id;

    private Long userId;
    /**
     * 用户昵称
     */
    private String userNick;
    /**
     * 操作模块 1：oem管理；2：代理商管理；3：授理商管理；4：商户管理；
     */
    private Integer operateModule;
    /**
     * 操作内容
     */
    private String operateBody;
    /**
     * 操作类型 1：增加；2：修改；3：删除
     */
    private Integer type;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}
