package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 功能：
 * 创建时间：2017-12-15 14:59
 * 更新记录：
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserMerchantDTO {

    /**
     * 商户ID
     */
    private Long mid;

    /**
     * 代理商ID
     */
    private Long agentId;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 开此账号的上级代理商ID
     */
    private Long belong;
    /**
     * 代理商到期时间
     */
    private String vipTime;
    /**
     * 代理商用户状态  1 启用 2 锁定
     */
    private Integer status;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 创建时间
     */
    private Date createTime;


    /**
     * username
     */
    private String username;

    private String provinceName;
    /**
     * 城市名称（gaode）
     */
    private String cityName;
    /**
     * 区域名称（gaode）
     */
    private String areaName;

    /**
     * 代理商公司名称
     */
    private String company;

    /**
     * 商户名称
     */
    private String title;
    private Integer authStatus;
    /**
     * 绑卡状态 0未绑定 1已绑定
     */
    private Integer bindStatus;
    /**
     * 是否已进件清算平台 0 未进件 1 已进件
     */
    private Integer isSettled;
    /**
     * 清算平台分配唯一ID
     */
    private String liquidationMerchantId;
}
