/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 功能：商户子账号角色请求参数对象
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserMerchantChildrenRoleParam {

    /**
     * 角色ID
     */
    private Long roleId;

    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 角色名称
     */
    private String name;
    /**
     * 备注
     */
    private String remark;
    /**
     * 权限节点
     */
    private String accessList;
    /**
     * 是否激活 1：是 0：否
     */
    private Integer status;
    /**
     * 角色类型 1店长 2 收银员 3 服务员
     */
    private Integer roleType;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;



}
