package com.fshows.lifecircle.service.user.openapi.facade.domain.agent;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 功能：代理商信息
 * 创建时间：2017-12-15 14:59
 * 更新记录：
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AgentInfo {

    /**
     * ID
     */
    private Long id;
    /**
     * 旧系统代理商ID
     */
    private Integer oAgentD;
    /**
     * 代理商ID
     */
    private Long agentId;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 代理费用 单位：元
     */
    private Integer agentFee;
    /**
     * 开此账号的上级代理商ID
     */
    private Long belong;
    /**
     * 代理级别  受理商 0  1全国代理 2省级代理 3市级代理 4区域代理
     */
    private Integer level;
    /**
     * 是否自营 1是 0否
     */
    private Integer isSelfSupport;
    /**
     * 代理商到期时间
     */
    private Long vipTime;
    /**
     * 代理商用户状态  1 启用 2 锁定
     */
    private Integer status;
    /**
     * 审核状态 0 待审核 1 审核通过 2审核失败
     */
    private Integer checkStatus;
    /**
     * 审核时间
     */
    private Long checkTime;
    /**
     * 备注说明
     */
    private String remark;
    /**
     * 公司
     */
    private String company;
    /**
     * 代理省份code（gaode）
     */
    private String agentProvinceCode;
    /**
     * 代理省份名称
     */
    private String agentProvinceName;
    /**
     * 代理城市code（gaode）
     */
    private String agentCityCode;
    /**
     * 代理城市名称
     */
    private String agentCityName;
    /**
     * 代理区域code（gaode）
     */
    private String agentAreaCode;
    /**
     * 代理区域名称
     */
    private String agentAreaName;
    /**
     * 所属行业
     */
    private String industry;
    /**
     * 主营业务
     */
    private String mainBiz;
    /**
     * 公司人数
     */
    private String companyPerson;
    /**
     * 年营业额
     */
    private String yearTurnover;
    /**
     * 上传合同等必要的证明文件的扫描件图片地址
     */
    private String verifyImages;
    /**
     * 公司logo
     */
    private String logo;

    /**
     * 联系人
     */
    private String linkmen;
    /**
     * 联系方式
     */
    private String contact;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}
