/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2017-12-18 19:42
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.OemNodeQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.OemNodeResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * 功能：oem 节点 api
 * 创建时间：2017-12-18 19:42
 * 更新记录：
 *
 * @author BuHao
 */
public interface IOemNodeApi {

  /**
   * 添加或修改 oem 节点对象
   */
  BizResponse addAndUpdateOemNode(OemNodeAddOrUpdateParam param);


  /**
   * @deprecated 使用树形返回列表
   * oem 节点列表接口
   */

  @Deprecated
  BizResponse<List<OemNodeResult>> findByPage(OemNodeQueryParam param);

  BizResponse getOemNodezByTree(long oemId);

  BizResponse getAllOemNodezTree();

  /**
   * 菜单详情
   */
  BizResponse<OemNodeDetailResult> getById(Long id);
}
