/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2017-12-22 10:09
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.NodeParam;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2017-12-22 10:09
 * 更新记录：
 * @author BuHao
 */
public interface INodeApi {

  /**
   * 根据用户 id 获得节点树
   * @param userId
   * @return
   */
  BizResponse<List<NodeParam>> getNodeTreeByUserId(Long userId);

  /**
   * 根据权限 id 获得节点树
   * @param roleId
   * @return
   */
  BizResponse<List<NodeParam>> getNodeTreeByRoleId(Long roleId);

  /**
   * 添加修改节点
   * @param nodeIds
   * @param roleId
   * @return
   */
  BizResponse addAndUpdateNode(List<Long> nodeIds, Long roleId);


  /**
   * 添加修改oem节点
   * @param nodeIds
   * @param roleId
   * @return
   */
  BizResponse addAndUpdateOemNode(List<Long> nodeIds, Long roleId);
}
