/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.AppLoginInfoParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginConfigParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.LoginParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.AppLoginInfoResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginConfigResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.LoginResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
public interface ILoginApi {

  /**
   * 用户登录
   */
  BizResponse<LoginResult> login(LoginParam loginParam);

  /**
   * 登录配置获取接口
   */
  BizResponse<LoginConfigResult> getLoginConfig(LoginConfigParam loginConfigParam);

  /**
   * 获得 app 登录信息
   */
  BizResponse<AppLoginInfoResult> getAppLoginInfo(AppLoginInfoParam param);

  /**
   * app 退出登录
   */
  BizResponse appLoginOut(String accessToken);
}
