package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindInfoSavaParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.BankBindRecordSaveParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantBankBindSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindInfoWithAuthResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.BankBindRecoredResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantBankBindDetailLists;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * @author spafka
 * 绑卡相关
 */
public interface IBankBindApi {

    BizResponse<Boolean> saveBankBindRecord(BankBindRecordSaveParam param);

    BizResponse<Boolean> saveBankBindInfo(BankBindInfoSavaParam param);

    BizResponse<PageResult<MerchantBankBindDetailLists>> merchantBankBindDetailList(MerchantBankBindSearchParam param);

    BizResponse<BankBindInfoWithAuthResult> getBindInfoByMId(Long bindId);

    BizResponse<PageResult<BankBindRecoredResult> > getBankBindRecord(Long mid,Integer page,Integer pageSize);
}
