package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.app.AppPushChannelParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.app.AppUserDeviceParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.app.AppUserPushInfoParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.app.AppUserSettingParam;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;

import java.util.List;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2018/3/5
 * @author：Wendy
 */
public interface IAppUserPushApi {
    /**
     * 添加(修改)渠道信息
     * @param pushChannelParam
     * @return
     */
    BizResponse<Boolean> updateAppPushChannel(AppPushChannelParam pushChannelParam)throws RpcInvokingException;

    /**
     * 获取渠道信息
     * @param pushChannelId
     * @return
     */
    BizResponse<List<AppPushChannelParam>> getAppPushChannelByChannelId(Integer pushChannelId)throws RpcInvokingException;

    /**
     * 添加（修改）用户设备号录入
     * @param appUserDeviceParam
     * @return
     */
    BizResponse<Boolean> updateAppUserDevice(AppUserDeviceParam appUserDeviceParam)throws RpcInvokingException;

    /**
     * 添加（修改）用户详情
     * @param appUserPushInfoParam
     * @return
     */
    BizResponse<Boolean> updateAppUserInfo(AppUserPushInfoParam appUserPushInfoParam)throws RpcInvokingException;

    /**
     * 添加（修改）用户语音配置
     * @param appUserSettingParam
     * @return
     */
    BizResponse<Boolean> updateAppUserSetting(AppUserSettingParam appUserSettingParam)throws RpcInvokingException;

    /**
     * 获取用户语音配置
     * @param userId
     * @return
     */
    BizResponse<AppUserSettingParam> getAppUserSetting(Long userId)throws RpcInvokingException;

    /**
     * 语音推送回调修改状态
     * @param id
     * @param status
     * @return
     */
    BizResponse<Boolean> updatePushType(Long id, Integer status)throws RpcInvokingException;

    /**
     * 发起推送（交易中心-订单完成）
     * @param content
     * @return
     */
    BizResponse<Boolean> apiPush(String content)throws RpcInvokingException;
}
