/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.params;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.domain.params
 * 功能：
 * 创建时间：2018-01-30 14:16
 * 更新记录：
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class MerchantSettleAddOrUpdateParam {
  /**
   * 入驻唯一ID
   */
  private Boolean settleId;
  /**
   * 商户ID
   */
  private Long mid;
  /**
   * 入驻渠道 1支付宝 2微信
   */
  private Integer settleChannel;
  /**
   * 是否入驻成功 1：是 0：否
   */
  private Integer status;
  /**
   * 入驻请求的信息（json）
   */
  private String requestData;
  /**
   * 商户入驻接口返回信息
   */
  private String msg;
  /**
   * 微信配置步数 1配置sub_appid 2配置subscribe_appid 3 path1 4 path2 5 path3 6 path4 7 path5
   */
  private Integer step;
  /**
   * 是否删除 0否 1是
   */
  private Integer isDel;
}
