/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 功能：商户查询对象
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MerchantQuery {

    /**
     * 分页查询 每页条数
     */
    private Integer pageSize = 20;

    /**
     * 第几页
     */
    private Integer page = 1;


    private boolean isExpire = false;

    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 开此账号的代理商ID
     */
    private Long agentId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 状态 1 启用 2锁定
     */
    private Integer status;

    /**
     * 用户名称
     */
    private String username;

    /**
     * 商户名称
     */
    private String title;

    /**
     * 根据过期条件搜索
     */
    private boolean expireFlag;


    /**
     * 所属代理商名称
     */
    private String agentName;
}
