package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.UserMercgantAuthenticationParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.MerchantAuthSearchParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.FbMerchantAuthenticationResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.MerchantAuthListResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;


/**
 * @author spafka
 */
public interface IUserMerchantAuthApi {

    /**
     * 根据authId save or update
     *
     * @param param
     * @return
     */
    BizResponse<FbMerchantAuthenticationResult> saveMerchantAuth(UserMercgantAuthenticationParam param);

    /**
     * 查询审核详情，如无，返回失败
     *
     * @param mid
     * @return
     */
    BizResponse<FbMerchantAuthenticationResult> getMerchantAuthDetail(Long mid);


    /**
     * search
     */
    BizResponse<PageResult<MerchantAuthListResult>> findFbMerchantAuthenticationResults(MerchantAuthSearchParam param);

}
