package com.fshows.lifecircle.service.user.openapi.facade.domain.result;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BankBindInfoWithAuthResult {

    /**
     * 绑定信息唯一标识
     */
    private Long bindId;
    /**
     * 商户唯一标识
     */
    private Long mid;
    /**
     * 银行唯一标识
     */
    private Long bankId;
    /**
     * 超级网银号
     */
    private String bankNo;
    /**
     * 银行名
     */
    private String bankName;
    /**
     * 银行卡号
     */
    private String acctId;
    /**
     * 个人认证姓名
     */
    private String name;
    /**
     * 银行卡预留手机号
     */
    private String bankMobile;
    /**
     * 企业认证营业执照号
     */
    private String licenseNumber;
    /**
     * 绑定类型 1个人绑定 2企业绑定
     */
    private Integer bindType;
    /**
     * 添加来源 1app端   2pc端
     */
    private Integer addFrom;
    /**
     * 是否删除 0未删除 1已删除
     */

    private Integer isDel;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 实名认证ID
     */
    private Long authId;
    /**
     * 身份证姓名
     */
    private String idname;
    /**
     * 身份证号
     */
    private String idcard;
    /**
     * 身份证照片
     */
    private String idcardphoto;
    /**
     * 营业执照编号
     */
    private String licenseid;
    /**
     * 营业执照名称（公司名称）
     */
    private String licensename;
    /**
     * 营业执照图片
     */
    private String licensephoto;
    /**
     * 企业法人姓名
     */
    private String legalPerson;
    /**
     * 法人身份证号码
     */
    private String legalIdcard;
    /**
     * 法人身份证图片
     */
    private String legalIdphoto;
    /**
     * 实名认证时间戳
     */
    private Long authTime;
    /**
     * 0未认证，1认证中/待认证，2认证成功，3认证失败
     */
    private Integer authStatus;
    /**
     * 0未审核，1审核中/待审核，2审核通过，3审核失败
     */
    private Integer verifyStatus;
    /**
     * 客服审核处理时间
     */
    private Integer handleTime;
    /**
     * 客服拒绝以后填写理由
     */
    private String rejectReason;
    /**
     * 1：个人用户；2：企业
     */
    private Integer type;
    /**
     * 实名认证审核方式 0人工审核 1接口审核
     */
    private Integer examineType;
}
