package com.fshows.lifecircle.service.user.openapi.facade.domain.params;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MerchantBankBindSearchParam {

    /**
     * 商户名称
     */
    private String title;
    /**
     * 商户手机号
     */
    private String contact;
    /**
     * 绑定状态0false1true
     */
    private Integer bindStatus;
    /**
     * 绑定类型:1个人绑定,2企业绑定
     */
    private Integer bindType;

    /**
     * page
     */
    private Integer page = 1;
    /**
     * pageSize
     */
    private Integer pageSize = 20;
}
