/*
 * Licensed under the Apache License; Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing; software
 * distributed under the License is distributed on an "AS IS" BASIS;
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND; either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: spafka@github.com
 * @desc: 代理商管理商户列表
 * @date: created on 2017-12-25 11:10:25.945
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MerchantListSeachByAgentResult {

    Long mid;
    String username;
    String title;
    String linkmen;
    String contact;
    String company;
    String agentAreaName;
    Date lastLoginTime;
    Integer status;
    String agentProvinceName;
    String agentCityName;
    Date createTime;
    BigDecimal weiChatFee;
    BigDecimal weiCommissionRate;
    BigDecimal alipayFee;
    BigDecimal alipayCommissionRate;

    Long agentVipTime;

}
