package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 功能：商户信息
 * 创建时间：2017-12-15 14:59
 * 更新记录：
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MerchantInfo {


    /**
     * ID
     */
    private Long id;
    /**
     * 旧系统商户token
     */
    private Integer oMid;
    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 开此账号的代理商ID
     */
    private Long agentId;
    /**
     * OEM商ID
     */
    private Long oemId;
    /**
     * 状态 1 启用 2锁定
     */
    private Integer status;
    /**
     * 商户名称
     */
    private String title;
    /**
     * 类目ID
     */
    private String categoryId;
    /**
     * 商户到期时间
     */
    private Long vipTime;
    /**
     * 备注说明
     */
    private String remark;
    /**
     * 联系人
     */
    private String linkmen;
    /**
     * 联系方式
     */
    private String contact;

    private Integer authStatus;
    /**
     * 绑卡状态 0未绑定 1已绑定
     */
    private Integer bindStatus;
    /**
     * 是否已进件清算平台 0 未进件 1 已进件
     */
    private Integer isSettled;
    /**
     * 清算平台分配唯一ID
     */
    private String liquidationMerchantId;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}
