/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MerchantChildDetailsResult {



    /**
     * 用户ID
     */
    private Long baseId;
    /**
     * 用户类型 1 OEM商 2代理商 3授理商 4商户
     */
    private Integer userType;
    /**
     * 是否子账户 0否 1是
     */
    private Integer isChild;
    /**
     * 用户名
     */
    private String username;
    /**
     * 用户状态 1 正常 0禁用
     */
    private Integer status;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * QQ
     */
    private String qq;
    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 省份code（gaode）
     */
    private String provinceCode;
    /**
     * 省份名称（gaode）
     */
    private String provinceName;
    /**
     * 城市code（gaode）
     */
    private String cityCode;
    /**
     * 城市名称（gaode）
     */
    private String cityName;
    /**
     * 区域code（gaode）
     */
    private String areaCode;
    /**
     * 区域名称（gaode）
     */
    private String areaName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 最后一次登录IP
     */
    private Long lastLoginIp;
    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;
    /**
     * 登录错误次数
     */
    private Integer loginErrorCount;
    /**
     * 登录锁定时间
     */
    private Long loginLockTime;
    /**
     * 平台 1：运营后台
     */
    private Integer platform;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * ID
     */
    private Long id;
    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 门店ID
     */
    private Long storeId;

    /**
     * 角色ID
     */
    private Integer roleId;
    /**
     * 角色名称
     */
    private String name;
    /**
     * 备注
     */
    private String remark;

    /**
     * 是否可退款
     */
    private Integer isRefund;
    /**
     * 是否可收银
     */
    private Integer isCashier;

}
