/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-12 15:15
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.*;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.app.StaffListParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffDetailResult;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.app.StaffListResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api
 * 功能：
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 *
 * @author caofy
 */
public interface IUserMerchantChildrenApi {

    /**
     * 商户子账号信息删除
     *
     * @param baseId
     * @return
     */
    BizResponse<Boolean> deleteUserMerchantChildrenByBaseId(Long baseId);

    /**
     * 商户子账号信息查询
     *
     * @param baseId
     * @return
     */
    BizResponse<MerchantChildrenDetailDTO> getUserMerchantChildrenByBaseId(Long baseId);

    /**
     * 商户子账号信息添加
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> addUserMerchantChildren(UserMerchantChildrenParam param);

    /**
     * 商户子账号信息修改
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> updateUserMerchantChildren(UserMerchantChildrenParam param);


    /**
     * 商户子账号角色添加
     *
     * @param param
     * @return
     */
    BizResponse<Long> addUserMerchantChildrenRole(UserMerchantChildrenRoleParam param);


    /**
     * 商户子账号角色修改
     *
     * @param param
     * @return
     */
    BizResponse<Boolean> updateUserMerchantChildrenRole(UserMerchantChildrenRoleParam param);

    BizResponse<MerchantChildDetailsResult> getUserMerchantChild(MerchantChildQueryParam param);


    /**
     * 删除角色
     *
     * @param roleId
     * @return
     */

    BizResponse<Boolean> deleteUserMerchantChildrenRole(Long roleId);


    /**
     * 获取角色列表
     *
     * @param childrenRoleQuery
     * @return
     */
    BizResponse<List<MerchantChildRoleResult>> getMerchantChildrenRoleListByCondition(ChildrenRoleQuery childrenRoleQuery);

    /**
     * 获取角色列表
     *
     * @param mid
     * @return
     */
    BizResponse<List<MerchantChildRoleResult>> getMerchantChildrenRoleList(Long mid, String roleName);

    /**
     * 根据roleId获取详情
     *
     * @param roleId
     * @return
     */
    BizResponse<MerchantChildRoleResult> getMerchantChildrenRoleByRoleId(Long roleId);

    /**
     * 获取员工列表
     */
    BizResponse<PageResult<StaffListResult>> getStaffListResult(StaffListParam param);

    /**
     * 获取员工详情
     */
    BizResponse<StaffDetailResult> getStaffDetailResult(Long uid);
}
