package com.fshows.lifecircle.service.user.openapi.facade.domain.result.commons;

/**
 * 项目：lifecircle-business-advertising
 * 包名：com.fshows.lifecircle.business.advertising.openapi.facade.domain.result
 * 功能：
 * 创建时间：2017-09-28 11:01
 * 更新记录：
 * @author ：BuHao
 */
public enum ErrorCodeEnum {

  /**
   * 数据操作失败
   */
  DATA_OPERATION_FAILURE("DATA_OPERATION_FAILURE", "数据操作失败"),
  /**
   * 无效参数
   */
  INVALID_PARAMETER("INVALID_PARAMETER", "无效参数"),
  /**
   * 服务器错误
   */
  SERVER_ERROR("SERVER_ERROR", "服务器错误"),
  /**
   * 请求方法错误
   */
  REQUEST_METHOD_ERROR("REQUEST_METHOD_ERROR", "请求方法错误"),
  /**
   * 媒体类型不支持
   */
  MEDIA_NOT_SUPPORT_ERROR("MEDIA_NOT_SUPPORT_ERROR", "媒体类型不支持"),
  /**
   * 用户名不存在
   */
  USERNAME_NOT_EXIST("USERNAME_NOT_EXIST", "用户名不存在"),
  /**
   *用户名存在
   */
  USER_NOT_EXIST("USER_NOT_EXIST", "用户不存在"),

  /**
   *用户已存在
   */
  USER_HAS_EXIST("USERNAME_HAS_EXIST", "用户已存在"),

  /**
   *该用户名不允许注册
   */
  USERNAME_HAS_DISALLOW("USERNAME_HAS_DISALLOW", "该用户名不允许注册"),

  /**
   * 用户名不存在
   */
  PASSWORD_ERROR("PASSWORD_ERROR", "密码错误"),
  /**
   * 用户类型不匹配
   */
  USERTYPE_ERROR("USERTYPE_ERROR", "用户类型错误"),
  /**
   * 账号禁用
   */
  USER_DISABLE("USER_DISABLE", "用户已关闭"),
  /**
   * 用户过期
   */
  USER_OVERDUE("USER_OVERDUE", "用户过期"),
  /**
   * 登录配置获取失败
   */
   NO_HAVE_LOGIN_CONFIG("NO_HAVE_LOGIN_CONFIG", "没有登录配置"),
  /**
   * 地址错误
   */
  PATH_NOT_FOUND("PATH_NOT_FOUND", "地址错误"),

  /**
   * 登录已被锁定
   */
  LOGIN_LOCK("LOGIN_LOCK", "登录已被锁定"),

  /**
   *站点不存在
   */
  NODE_NOT_EXIST("NODE_NOT_EXIST", "站点不存在"),
  /**
   *站点已存在
   */
  NODE_HAS_EXIST("NODE_HAS_EXIST", "站点已存在"),
  /**
   *无符合条件记录
   */
   NO_DATA_BY_CONDITIONS("NO_DATA_BY_CONDITIONS", "无符合条件记录"),


  /**
   * 基础用户信息添加错误
   */
  USER_BASE_ERROR("USER_BASE_ERROR", "基础用户信息添加错误"),

  OEM_CONFIG_NOT_EXIT("OEM_CONFIG_NOT_EXIT", "OEM信息未配置");




  /**
   * 错误码
   */
  private String code;
  /**
   * 错误信息
   */
  private String msg;

  ErrorCodeEnum(String code, String msg) {
    this.code = code;
    this.msg = msg;
  }

  /**
   * 获得错误码
   * @return
   */
  public String getCode() {
    return this.code;
  }

  /**
   * 获得错误信息
   * @return
   */
  public String getMsg() {
    return this.msg;
  }
}
