/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.merchant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MerchantChildrenResult {

    /**
     * ID
     */
    private Long id;
    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 门店ID
     */
    private Long storeId;

    /**
     * 角色ID
     */
    private Integer roleId;
    /**
     * 角色名称
     */
    private String name;
    /**
     * 备注
     */
    private String remark;


    /**
     * 是否激活 1：是 0：否
     */
    private Integer status;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;


}
