/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.user.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryPageParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.params.RoleQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.RoleResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.service.user.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2017-12-18 10:11
 * 更新记录：
 * @author BuHao
 */
public interface IRoleApi {

  /**
   * 角色列表接口
   * @param roleQueryPageParam
   * @return
   */
  BizResponse<PageResult<RoleResult>> findRoleListByPage(RoleQueryPageParam roleQueryPageParam);

  /**
   * 添加或修改角色
   * @param param
   * @return
   */
  BizResponse addOrUpdate(RoleAddOrUpdateParam param);

  /**
   * 角色详情查询接口
   * @param param
   * @return
   */
  BizResponse<RoleResult> getRole(RoleQueryParam param);
}
