/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;


@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OemResult implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户类型 1 OEM商 2代理商 3授理商 4商户
     */
    private Integer userType;
    /**
     * 是否子账户 0否 1是
     */
    private Integer isChild;
    /**
     * 用户名
     */
    private String username;

    /**
     * 手机号
     */
    private String mobile;
    /**
     * QQ
     */
    private String qq;
    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 省份code（gaode）
     */
    private String provinceCode;
    /**
     * 省份名称（gaode）
     */
    private String provinceName;
    /**
     * 城市code（gaode）
     */
    private String cityCode;
    /**
     * 城市名称（gaode）
     */
    private String cityName;
    /**
     * 区域code（gaode）
     */
    private String areaCode;
    /**
     * 区域名称（gaode）
     */
    private String areaName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 最后一次登录IP
     */
    private Long lastLoginIp;
    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;
    /**
     * 登录错误次数
     */
    private Integer loginErrorCount;
    /**
     * 登录锁定时间
     */
    private Long loginLockTime;
    /**
     * 平台 1：运营后台
     */
    private Integer platform;

    private Integer isDel;


    /**
     * OEM_ID
     */
    private Long oemId;
    /**
     * 基础用户ID
     */
    private Long baseId;
    /**
     * 是否自营 1是 0否
     */
    private Integer isSelfSupport;
    /**
     * 总后台名称
     */
    private String adminTitle;
    /**
     * 品牌简称
     */
    private String brandName;

    /**
     * 总后台logo cleanImgUrl
     */
    private String adminLogo;
    /**
     * 首页欢迎语
     */
    private String welcomeWord;
    /**
     * 附属总后台登录页url
     */
    private String adminUrl;
    /**
     * 代理商后台logo cleanImgUrl
     */
    private String agentLogo;
    /**
     * 代理商后台登陆url
     */
    private String agentUrl;
    /**
     * 商户后台logo cleanImgUrl
     */
    private String userLogo;
    /**
     * 商户后台登陆url
     */
    private String userUrl;
    /**
     * 网页顶部文案（服务热线）
     */
    private String topMsg;
    /**
     * 网页底部文案
     */
    private String bottomMsg;
    /**
     * 收款语音和文字提示
     */
    private String voiceRemind;
    /**
     * 语音开关 1关 0开
     */
    private Integer voiceOnOff;
    /**
     * 绑卡协议 1 生活圈  2杉德
     */
    private Integer bindProtocol;
    /**
     * 视频是否显示  1隐藏 0显示
     */
    private Integer videoOnOff;
    /**
     * 红包文案
     */
    private String redPacketNotice;
    /**
     * 红包内容文案
     */
    private String redPacketMsg;
    /**
     * 附属总后台url结尾域名
     */
    private String subDomain;
    /**
     * 总后台登录背景
     */
    private String adminLoginBg;
    /**
     * 总后台登录logo
     */
    private String adminLoginLogo;
    /**
     * 总后台登录文案
     */
    private String adminLoginTitle;
    /**
     * 代理商登录背景
     */
    private String agentLoginBg;
    /**
     * 代理商登录页Logo
     */
    private String agentLoginLogo;
    /**
     * 代理商登录页标题
     */
    private String agentLoginTitle;
    /**
     * 商户登录背景
     */
    private String userLoginBg;
    /**
     * 商户登录页Logo
     */
    private String userLoginLogo;
    /**
     * 商户登录页标题
     */
    private String userLoginTitle;
    /**
     * 公众号
     */
    private String wxOfficialAccount;
    /**
     * 门店二维码背景图
     */
    private String qrcodeBackground;
    /**
     * 朋友圈广告投放联系方式
     */
    private String agentAdText;
    /**
     * h5页面首页标题
     */
    private String wapIndexTitle;
    /**
     * H5页面商家会员的默认头像
     */
    private String wapDefaultHeader;
    /**
     * H5顾客默认昵称
     */
    private String wapDefaultNickname;
    /**
     * H5页面顾客默认头像
     */
    private String wapUserHeader;
    /**
     * 绑卡协议标题
     */
    private String protocolTitle;
    /**
     * 绑卡协议内容
     */
    private String protocolContent;
    /**
     * 微信公众号AppID
     */
    private String wxMpAppid;
    /**
     * 微信公众号AppSecret
     */
    private String wxMpAppsecret;
    /**
     * 激品活会员验证码短信的品牌名
     */
    private String wapActiveBand;
    /**
     * 成为会员短信通知的品牌名
     */
    private String wapMemberBand;
    /**
     * 网站标题logo cleanImgUrl
     */
    private String webLogo;
    /**
     * app客服电话
     */
    private String appCustomerMobile;
    /**
     * app绑卡提示文案
     */
    private String appBindText;
    /**
     * 子商户号Id
     */
    private Integer configType;
    /**
     * 是否展示商户协议 1展示 0不展示
     */
    private Integer isShowProtocol;
    /**
     * 订单支付成功通知
     */
    private String paySuccessNotice;
    /**
     * 二维码海报文案
     */
    private String qrCodeUrl;
    /**
     * 海报文案
     */
    private String postDocument;
    /**
     * 海报背景
     */
    private String postLogo;
    /**
     * 创建时间
     */
    private Date createTime;





}
