/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.fshows.lifecircle.service.user.openapi.facade.domain.agent;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AgentAdminIndexResult {


    Integer toDayAccountNum;    //今日开户数
    Integer toYearAccountNum;    //本月开户数
    BigDecimal yesterdayPayNum;    //昨日交易总额
    BigDecimal toYearPayNum;    //本月交易总额
    Integer sumMerchantNum;    //总商户数
    Integer putawayShopNum;    //上架门店总数
}
