package com.fshows.lifecircle.service.user.openapi.facade.domain.userbase;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * 功能：user_base基本用户信息
 * 创建时间：2017-12-15 10:00
 * 更新记录：
 * @author caofy
 */

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseInfo {

    /**
     * ID
     */
    private Long id;
    /**
     * 旧系统用户ID
     */
    private Integer oUid;
    /**
     * 用户ID
     */
    private Long baseId;
    /**
     * 用户类型 1 OEM商 2代理商 3授理商 4商户
     */
    private Integer userType;
    /**
     * 是否子账户 0否 1是
     */
    private Integer isChild;
    /**
     * 用户名
     */
    private String username;
    /**
     * 用户密码
     */
    private String userpwd;
    /**
     * 加密密码 盐值
     */
    private String salt;
    /**
     * 用户状态 1 正常 0禁用
     */
    private Integer status;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * QQ
     */
    private String qq;
    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 省份code（gaode）
     */
    private String provinceCode;
    /**
     * 省份名称（gaode）
     */
    private String provinceName;
    /**
     * 城市code（gaode）
     */
    private String cityCode;
    /**
     * 城市名称（gaode）
     */
    private String cityName;
    /**
     * 区域code（gaode）
     */
    private String areaCode;
    /**
     * 区域名称（gaode）
     */
    private String areaName;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 最后一次登录IP
     */
    private Long lastLoginIp;
    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;
    /**
     * 登录错误次数
     */
    private Integer loginErrorCount;
    /**
     * 登录锁定时间
     */
    private Long loginLockTime;
    /**
     * 平台 1：运营后台
     */
    private Integer platform;
    /**
     * 是否删除 0否 1是
     */
    private Integer isDel;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;


}
