package com.fshows.lifecircle.service.user.openapi.facade.domain.params;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MerchantAuthSearchParam{


    private String title;
    private String contact;
    private String company;

    /**
     * 商户ID
     */
    private Long mid;
    /**
     * 身份证姓名
     */
    private String idname;
    /**
     * 身份证号
     */
    private String idcard;
    /**
     * 营业执照编号
     */
    private String licenseid;

    /**
     * 企业法人姓名
     */
    private String legalPerson;
    /**
     * 法人身份证号码
     */
    private String legalIdcard;

    /**
     * 0未认证，1认证中/待认证，2认证成功，3认证失败
     */
    private Integer authStatus;
    /**
     * 1：个人用户；2：企业
     */
    private Integer type;
    /**
     * 创建时间
     */
    private Date startTime;
    private Date endTime;

    Integer page=1;
    Integer pageSize=20;

}
